/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.auth.oauth;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.service.ClientFactory;
import org.gluu.oxauth.client.service.IntrospectionService;
import org.gluu.oxauth.model.common.IntrospectionResponse;
import org.gluu.oxtrust.auth.IProtectionService;
import org.gluu.oxtrust.service.JsonConfigurationService;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.slf4j.Logger;

public abstract class BaseOAuthProtectionService
implements IProtectionService,
Serializable {
    private static final long serialVersionUID = -1147131971095460010L;
    @Inject
    private Logger log;
    @Inject
    private JsonConfigurationService jsonConfigurationService;
    private IntrospectionService introspectionService;

    protected abstract Response processIntrospectionResponse(IntrospectionResponse var1, ResourceInfo var2);

    @Override
    public Response processAuthorization(HttpHeaders headers, ResourceInfo resourceInfo) {
        Response authorizationResponse;
        block5: {
            try {
                String token = headers.getHeaderString("Authorization");
                boolean authFound = StringUtils.isNotEmpty((String)token);
                this.log.info("Authorization header {} found", (Object)(authFound ? "" : "not"));
                if (authFound) {
                    token = token.replaceFirst("Bearer\\s+", "");
                    this.log.debug("Validating token {}", (Object)token);
                    IntrospectionResponse iresp = null;
                    try {
                        iresp = this.introspectionService.introspectToken("Bearer " + token, token);
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage());
                    }
                    authorizationResponse = this.processIntrospectionResponse(iresp, resourceInfo);
                    break block5;
                }
                this.log.info("Request is missing authorization header");
                authorizationResponse = IProtectionService.simpleResponse(Response.Status.UNAUTHORIZED, "No authorization header found");
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                authorizationResponse = IProtectionService.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
        }
        return authorizationResponse;
    }

    @PostConstruct
    private void init() {
        try {
            String introspectionEndpoint = this.jsonConfigurationService.getOxauthAppConfiguration().getIntrospectionEndpoint();
            this.introspectionService = ClientFactory.instance().createIntrospectionService(introspectionEndpoint, (ClientHttpEngine)ClientFactory.instance().createEngine());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

