/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.auth;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Provider;
import org.gluu.oxtrust.auth.BindingUrls;
import org.gluu.oxtrust.auth.GluuRestService;
import org.slf4j.Logger;

@ApplicationScoped
public class ProtectionServiceSelector {
    @Inject
    private Logger log;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<GluuRestService> gluuRestServiceInstance;
    private Map<String, Class<GluuRestService>> mapping;

    public GluuRestService select(String path) {
        return this.mapping.keySet().stream().filter(path::startsWith).findFirst().map(this.mapping::get).map(x$0 -> this.gluuRestServiceInstance.select(x$0, new Annotation[0])).map(Provider::get).orElse(null);
    }

    @PostConstruct
    private void init() {
        this.mapping = new HashMap<String, Class<GluuRestService>>();
        Set beans = this.beanManager.getBeans(GluuRestService.class, new Annotation[]{Any.Literal.INSTANCE});
        for (Bean bean : beans) {
            Class beanClass = bean.getBeanClass();
            Optional.ofNullable(beanClass.getAnnotation(BindingUrls.class)).map(BindingUrls.class::cast).map(BindingUrls::value).map(Arrays::asList).orElse(Collections.emptyList()).forEach(pattern -> {
                if (pattern.length() > 0) {
                    this.mapping.put((String)pattern, beanClass);
                }
            });
        }
    }
}

