/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.auth;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.oxtrust.auth.BindingUrls;
import org.gluu.oxtrust.auth.GluuRestService;
import org.gluu.oxtrust.auth.IProtectionService;
import org.gluu.oxtrust.auth.oauth.DefaultTestModeProtectionService;
import org.gluu.oxtrust.auth.uma.ApiUmaProtectionService;
import org.slf4j.Logger;

@ApplicationScoped
@BindingUrls(value={"/api/v1"})
public class OxTrustApiService
implements GluuRestService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ApiUmaProtectionService apiUmaProtectionService;
    @Inject
    private DefaultTestModeProtectionService testModeProtectionService;

    @Override
    public String getName() {
        return "oxTrust API";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public IProtectionService getProtectionService() {
        boolean testMode = this.appConfiguration.isOxTrustApiTestMode();
        this.log.info("oxTrust API protection mode is {}", (Object)(testMode ? "TEST" : "UMA"));
        return testMode ? this.testModeProtectionService : this.apiUmaProtectionService;
    }
}

