/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.util;

import com.unboundid.util.StaticUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.TimeZone;

public class DateUtil {
    private DateUtil() {
    }

    public static Long ISOToMillis(String strDate) {
        ZonedDateTime ta = null;
        try {
            ta = ZonedDateTime.parse(strDate);
        }
        catch (Exception e) {
            try {
                LocalDateTime.parse(strDate);
                String zoneId = ZoneOffset.ofTotalSeconds(TimeZone.getDefault().getRawOffset() / 1000).toString();
                ta = ZonedDateTime.parse(strDate + zoneId);
            }
            catch (Exception e1) {
                return null;
            }
        }
        try {
            return Instant.from(ta).toEpochMilli();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String ISOToGeneralizedStringDate(String strDate) {
        return Optional.ofNullable(DateUtil.ISOToMillis(strDate)).map(StaticUtils::encodeGeneralizedTime).orElse(null);
    }

    public static String generalizedToISOStringDate(String strDate) {
        try {
            return DateUtil.millisToISOString(StaticUtils.decodeGeneralizedTime((String)strDate).getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String millisToISOString(long millis) {
        return Instant.ofEpochMilli(millis).toString();
    }

    public static String gluuCouchbaseISODate(String value) {
        try {
            String gluuISODate = ZonedDateTime.parse(value).format(DateTimeFormatter.ISO_INSTANT);
            return gluuISODate.substring(0, gluuISODate.length() - 1);
        }
        catch (Exception e) {
            try {
                LocalDateTime.parse(value);
                return value;
            }
            catch (Exception e1) {
                return null;
            }
        }
    }
}

