/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.util;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtil {
    public static final String GENERALIZED_TIME_FORMAT = "YYYYMMddHHmmss.SSSZ";

    private DateUtil() {
    }

    public static String ISOToGeneralizedStringDate(String strDate) {
        String utcFormatted = null;
        try {
            if (strDate.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.*")) {
                DateTime dt = new DateTime((Object)strDate);
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)GENERALIZED_TIME_FORMAT);
                utcFormatted = fmt.withZone(DateTimeZone.UTC).print((ReadableInstant)dt);
                utcFormatted = utcFormatted.substring(0, utcFormatted.length() - 5) + "Z";
            }
        }
        catch (Exception e) {
            utcFormatted = null;
        }
        return utcFormatted;
    }

    public static String generalizedToISOStringDate(String strDate) {
        String isoFormatted;
        try {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)GENERALIZED_TIME_FORMAT);
            DateTime dt = fmt.parseDateTime(strDate);
            isoFormatted = ISODateTimeFormat.dateTime().print((ReadableInstant)dt);
        }
        catch (Exception e) {
            isoFormatted = null;
        }
        return isoFormatted;
    }

    public static String millisToISOString(long millis) {
        DateTime dt = new DateTime(millis);
        return ISODateTimeFormat.dateTime().print((ReadableInstant)dt);
    }

    public static String gluuCouchbaseISODate(String value) {
        try {
            String gluuISODate = ZonedDateTime.parse(value).format(java.time.format.DateTimeFormatter.ISO_INSTANT);
            return gluuISODate.substring(0, gluuISODate.length() - 1);
        }
        catch (Exception e) {
            try {
                LocalDateTime.parse(value);
                return value;
            }
            catch (Exception e1) {
                return null;
            }
        }
    }
}

