/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.user;

import org.apache.commons.lang.StringUtils;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.annotations.StoreReference;

public class Name {
    @Attribute(description="The family name of the User, or Last  Name in most Western languages (for example, Jensen given the full name Ms. Barbara J Jensen, III.).")
    @StoreReference(ref="sn")
    private String familyName;
    @Attribute(description="The given name of the User, or First Name  in most Western languages (for example, Barbara given the full name Ms. Barbara J Jensen, III.).")
    @StoreReference(ref="givenName")
    private String givenName;
    @Attribute(description="The middle name(s) of the User (for example,  Robert given the full name Ms. Barbara J Jensen, III.).")
    @StoreReference(ref="middleName")
    private String middleName;
    @Attribute(description="The honorific prefix(es) of the User, or  Title in most Western languages (for example, Ms. given the full name Ms. Barbara J Jensen, III.).")
    @StoreReference(ref="oxTrusthonorificPrefix")
    private String honorificPrefix;
    @Attribute(description="The honorific suffix(es) of the User, or  Suffix in most Western languages (for example, III. given the full name Ms. Barbara J Jensen, III.)")
    @StoreReference(ref="oxTrusthonorificSuffix")
    private String honorificSuffix;
    @Attribute(description="The full name, including all middle names, titles, and suffixes as appropriate, formatted for display (for example, Ms. Barbara J Jensen, III.).")
    @StoreReference(ref="oxTrustNameFormatted")
    private String formatted;

    public String computeFormattedName() {
        if (StringUtils.isEmpty((String)this.formatted)) {
            String formattedName = "";
            formattedName = formattedName + (StringUtils.isEmpty((String)this.honorificPrefix) ? "" : this.honorificPrefix + " ");
            formattedName = formattedName + (StringUtils.isEmpty((String)this.givenName) ? "" : this.givenName + " ");
            formattedName = formattedName + (StringUtils.isEmpty((String)this.middleName) ? "" : this.middleName + " ");
            formattedName = formattedName + (StringUtils.isEmpty((String)this.familyName) ? "" : this.familyName + " ");
            formattedName = formattedName + (StringUtils.isEmpty((String)this.honorificSuffix) ? "" : this.honorificSuffix);
            formattedName = formattedName.trim();
            this.formatted = formattedName.length() == 0 ? null : formattedName;
        }
        return this.formatted;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public void setFormatted(String formatted) {
        this.formatted = formatted;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getHonorificPrefix() {
        return this.honorificPrefix;
    }

    public void setHonorificPrefix(String honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    public String getHonorificSuffix() {
        return this.honorificSuffix;
    }

    public void setHonorificSuffix(String honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }
}

