/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.provider.resourcetypes;

import java.util.List;
import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.BaseScimResource;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.annotations.Schema;
import org.gluu.oxtrust.model.scim2.provider.resourcetypes.SchemaExtensionHolder;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:ResourceType", name="Resource Type", description="Specifies the metadata about a resource")
public class ResourceType
extends BaseScimResource {
    @Attribute(description="The resource type name.", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String name;
    @Attribute(description="The resource type's human-readable description", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String description;
    @Attribute(description="The resource type's HTTP-addressable endpoint relative to the Base URL of the service provider, e.g., \"Users\".", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String endpoint;
    @Attribute(description="The resource type's primary/base schema URI, e.g., \"urn:ietf:params:scim:schemas:core:2.0:User\".This MUST be equal to the \"id\" attribute of the associated \"Schema\" resource", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String schema;
    @Attribute(description="A list of URIs of the resource type's schema extensions.", mutability=AttributeDefinition.Mutability.READ_ONLY, multiValueClass=SchemaExtensionHolder.class, type=AttributeDefinition.Type.COMPLEX)
    private List<SchemaExtensionHolder> schemaExtensions;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<SchemaExtensionHolder> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    public void setSchemaExtensions(List<SchemaExtensionHolder> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
    }
}

