/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.group;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member {
    @Attribute(description="The value of an 'id' attribute of a SCIM resource", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    private String value;
    @Attribute(description="The URI of a SCIM resource such as a 'User', or a 'Group'", referenceTypes={"User"}, mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.REFERENCE)
    @JsonProperty(value="$ref")
    private String ref;
    @Attribute(description="A label indicating the type of resource, e.g., 'User' or 'Group'.", canonicalValues={"User"}, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    private String type;
    @Attribute(description="A human readable name, primarily used for display purposes.", mutability=AttributeDefinition.Mutability.IMMUTABLE)
    private String display;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Member other = (Member)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.display == null ? other.display != null : !this.display.equals(other.display));
    }
}

