/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.fido;

import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.BaseScimResource;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.annotations.Schema;
import org.gluu.oxtrust.model.scim2.annotations.StoreReference;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:FidoDevice", name="FidoDevice", description="Fido Device")
public class FidoDeviceResource
extends BaseScimResource {
    @Attribute(description="Username of device owner", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    private String userId;
    @Attribute(description="Date of enrollment", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.DATETIME)
    @StoreReference(ref="creationDate")
    private String creationDate;
    @Attribute(description="Application ID that enrolled the device", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    @StoreReference(ref="oxApplication")
    private String application;
    @Attribute(description="A counter aimed at being used by the FIDO endpoint", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.INTEGER)
    @StoreReference(ref="oxCounter")
    private String counter;
    @Attribute(description="A Json representation of low-level attributes of this device", mutability=AttributeDefinition.Mutability.IMMUTABLE)
    @StoreReference(ref="oxDeviceData")
    private String deviceData;
    @Attribute(description="", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.INTEGER)
    @StoreReference(ref="oxDeviceHashCode")
    private String deviceHashCode;
    @Attribute(description="", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    @StoreReference(ref="oxDeviceKeyHandle")
    private String deviceKeyHandle;
    @Attribute(description="", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    @StoreReference(ref="oxDeviceRegistrationConf")
    private String deviceRegistrationConf;
    @Attribute(description="The most recent dateTime when this device was used for authentication", mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.DATETIME)
    @StoreReference(ref="oxLastAccessTime")
    private String lastAccessTime;
    @Attribute(isRequired=true, canonicalValues={"active", "compromised"})
    @StoreReference(ref="oxStatus")
    private String status;
    @Attribute
    @StoreReference(ref="displayName")
    private String displayName;
    @Attribute
    @StoreReference(ref="description")
    private String description;
    @Attribute
    @StoreReference(ref="oxNickName")
    private String nickname;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getCounter() {
        return this.counter;
    }

    public void setCounter(String counter) {
        this.counter = counter;
    }

    public String getDeviceData() {
        return this.deviceData;
    }

    public void setDeviceData(String deviceData) {
        this.deviceData = deviceData;
    }

    public String getDeviceHashCode() {
        return this.deviceHashCode;
    }

    public void setDeviceHashCode(String deviceHashCode) {
        this.deviceHashCode = deviceHashCode;
    }

    public String getDeviceKeyHandle() {
        return this.deviceKeyHandle;
    }

    public void setDeviceKeyHandle(String deviceKeyHandle) {
        this.deviceKeyHandle = deviceKeyHandle;
    }

    public String getDeviceRegistrationConf() {
        return this.deviceRegistrationConf;
    }

    public void setDeviceRegistrationConf(String deviceRegistrationConf) {
        this.deviceRegistrationConf = deviceRegistrationConf;
    }

    public String getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(String lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
}

