/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.util;

import java.io.File;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;

public class X509CertificateShortInfo
implements Serializable {
    private static final long serialVersionUID = 135442950364886448L;
    private static final String HIGHLIGHT_STYLE_UNVALID = "background-color: rgb(255, 0, 0);";
    private static final String HIGHLIGHT_STYLE_VALID = "";
    private static final String HIGHLIGHT_STYLE_WARNING = "background-color: rgb(255, 255, 0);";
    private static final long NANOSEC_3_MONTH = 7776000000L;
    private String alias;
    private String issuer;
    private String subject;
    private String algorithm;
    private Date notBeforeDatetime;
    private Date notAfterDatetime;
    private String viewStyle;
    private boolean warning = false;
    private String path;

    public X509CertificateShortInfo() {
    }

    public X509CertificateShortInfo(String alias, X509Certificate cert) {
        this.alias = alias;
        if (cert.getIssuerDN() != null) {
            this.issuer = cert.getIssuerDN().getName();
        }
        if (cert.getSubjectDN() != null) {
            this.subject = cert.getSubjectDN().getName();
        }
        this.algorithm = cert.getSigAlgName();
        this.notBeforeDatetime = cert.getNotBefore();
        this.notAfterDatetime = cert.getNotAfter();
        this.updateViewStyle();
    }

    public X509CertificateShortInfo(String path, String alias, X509Certificate cert) {
        this(alias, cert);
        this.path = path;
    }

    public void updateViewStyle() {
        Date currentTime = new Date();
        Date time3MonthAfter = new Date(System.currentTimeMillis() + 7776000000L);
        if (currentTime.after(this.getNotAfterDatetime())) {
            this.setViewStyle(HIGHLIGHT_STYLE_UNVALID);
            this.warning = true;
        } else if (this.getNotBeforeDatetime().after(this.getNotAfterDatetime())) {
            this.setViewStyle(HIGHLIGHT_STYLE_UNVALID);
            this.warning = true;
        } else if (currentTime.before(this.getNotBeforeDatetime())) {
            this.setViewStyle(HIGHLIGHT_STYLE_WARNING);
            this.warning = true;
        } else if (time3MonthAfter.after(this.getNotAfterDatetime())) {
            this.setViewStyle(HIGHLIGHT_STYLE_UNVALID);
            this.warning = true;
        } else {
            this.setViewStyle(HIGHLIGHT_STYLE_VALID);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Date getNotBeforeDatetime() {
        return this.notBeforeDatetime;
    }

    public void setNotBeforeDatetime(Date notBeforeDatetime) {
        this.notBeforeDatetime = notBeforeDatetime;
    }

    public Date getNotAfterDatetime() {
        return this.notAfterDatetime;
    }

    public void setNotAfterDatetime(Date notAfterDatetime) {
        this.notAfterDatetime = notAfterDatetime;
    }

    public String getViewStyle() {
        return this.viewStyle;
    }

    public void setViewStyle(String viewStyle) {
        this.viewStyle = viewStyle;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public void setWarning(boolean warning) {
        this.warning = warning;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.path != null) {
            File file = new File(this.path);
            return file.getName();
        }
        return "certificate.crt";
    }

    public void setPath(String path) {
        this.path = path;
    }
}

