/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.table;

import java.io.Serializable;
import java.util.HashMap;
import org.gluu.oxtrust.model.table.Cell;

public class Table
implements Serializable {
    private static final long serialVersionUID = 2766629412918360302L;
    private HashMap<Integer, HashMap<Integer, Cell>> cells = new HashMap();
    private int countCols = -1;
    private int countRows = -1;

    public String getCellValue(int col, int row) {
        HashMap<Integer, Cell> rows = this.cells.get(col);
        if (rows == null) {
            return "";
        }
        Cell cell = rows.get(row);
        if (cell == null) {
            return "";
        }
        return cell.getValue();
    }

    public void addCell(Cell cell) {
        int col = cell.getCol();
        int row = cell.getRow();
        HashMap<Integer, Cell> rows = this.cells.get(col);
        if (rows == null) {
            rows = new HashMap();
            this.cells.put(col, rows);
        }
        rows.put(row, cell);
        this.countCols = Math.max(this.countCols, col);
        this.countRows = Math.max(this.countRows, row);
    }

    public int getCountCols() {
        return this.countCols;
    }

    public void setCountCols(int countCols) {
        this.countCols = countCols;
    }

    public int getCountRows() {
        return this.countRows;
    }

    public void setCountRows(int countRows) {
        this.countRows = countRows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table:\n");
        for (int i = 0; i < this.countCols; ++i) {
            sb.append("Column: ").append(i).append(":\t");
            for (int j = 0; j < this.countRows; ++j) {
                sb.append(this.getCellValue(i, j));
                if (j == this.countRows - 1) {
                    sb.append("\n");
                    continue;
                }
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

