/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum SignatureAlgorithm implements AttributeEnum
{
    NONE("none", "none"),
    HS256("HS256", "HS256"),
    HS384("HS384", "HS384"),
    HS512("HS512", "HS512"),
    RS256("RS256", "RS256"),
    RS384("RS384", "RS384"),
    RS512("RS512", "RS512"),
    ES256("ES256", "ES256"),
    ES384("ES384", "ES384"),
    ES512("ES512", "ES512");

    private String value;
    private String displayName;
    private static Map<String, SignatureAlgorithm> mapByValues;

    private SignatureAlgorithm(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static SignatureAlgorithm getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return SignatureAlgorithm.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, SignatureAlgorithm>();
        for (SignatureAlgorithm enumType : SignatureAlgorithm.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

