/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.logging.log4j.core.util.UuidUtil;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.Entry;

@DataEntry(sortBy={"description"})
@ObjectClass(value="oxSectorIdentifier")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OxAuthSectorIdentifier
extends Entry
implements Serializable {
    private static final long serialVersionUID = -2812480357430436514L;
    private transient boolean selected;
    @AttributeName(name="oxId", ignoreDuringUpdate=true)
    private String id;
    @NotNull
    @Size(min=0, max=250, message="Length of the Description should not exceed 250")
    @AttributeName(name="description")
    private @NotNull @Size(min=0, max=250, message="Length of the Description should not exceed 250") String description;
    @AttributeName(name="oxAuthRedirectURI")
    private List<String> redirectUris = new ArrayList<String>();
    @AttributeName(name="oxAuthClientId")
    private List<String> clientIds = new ArrayList<String>();

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<String> getClientIds() {
        return this.clientIds;
    }

    public void addNewClient(String clientInum) {
        ArrayList<String> clients = new ArrayList<String>();
        clients.addAll(this.clientIds);
        clients.remove(clientInum);
        clients.add(clientInum);
        this.clientIds = clients;
    }

    public void setClientIds(List<String> clientIds) {
        this.clientIds = clientIds;
    }

    public String getLoginUri() {
        return null;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "Default description " + UuidUtil.getTimeBasedUuid().toString().substring(0, 5);
        }
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String toString() {
        return String.format("OxAuthSectorIdentifier [id=%s, toString()=%s]", this.id, super.toString());
    }
}

