/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxtrust.model.AuthenticationMethod;
import org.gluu.oxtrust.model.BlockEncryptionAlgorithm;
import org.gluu.oxtrust.model.KeyEncryptionAlgorithm;
import org.gluu.oxtrust.model.OxAuthApplicationType;
import org.gluu.oxtrust.model.OxAuthSubjectType;
import org.gluu.oxtrust.model.SignatureAlgorithm;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.Entry;
import org.oxauth.persistence.model.ClientAttributes;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="oxAuthClient")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OxAuthClient
extends Entry
implements Serializable {
    private static final long serialVersionUID = -2310140703735705346L;
    private transient boolean selected;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=250, message="Length of the Description should not exceed 250")
    @AttributeName
    private @NotNull @Size(min=0, max=250, message="Length of the Description should not exceed 250") String description;
    @NotNull
    @AttributeName(name="oxAuthAppType")
    private OxAuthApplicationType oxAuthAppType;
    @AttributeName(name="oxAuthContact")
    private List<String> contacts;
    @AttributeName(name="oxAuthRedirectURI")
    private List<String> oxAuthRedirectURIs;
    @AttributeName(name="oxAuthPostLogoutRedirectURI")
    private List<String> oxAuthPostLogoutRedirectURIs;
    @AttributeName(name="oxAuthScope")
    private List<String> oxAuthScopes;
    @AttributeName(name="oxAuthClaim")
    private List<String> oxAuthClaims;
    @NotNull
    @AttributeName(name="oxAuthClientSecret")
    private String encodedClientSecret;
    @AttributeName(ignoreDuringUpdate=true)
    private String userPassword;
    @AttributeName(name="associatedPerson")
    private List<String> associatedPersons;
    @AttributeName(name="oxAuthTrustedClient")
    private Boolean oxAuthTrustedClient = Boolean.FALSE;
    @AttributeName(name="oxAuthResponseType")
    private ResponseType[] responseTypes;
    @AttributeName(name="oxAuthGrantType")
    private GrantType[] grantTypes;
    @AttributeName(name="oxAuthLogoURI")
    private String logoUri;
    @AttributeName(name="oxAuthClientURI")
    private String clientUri;
    @AttributeName(name="oxAuthPolicyURI")
    private String policyUri;
    @AttributeName(name="oxAuthTosURI")
    private String tosUri;
    @AttributeName(name="oxAuthJwksURI")
    private String jwksUri;
    @AttributeName(name="oxAuthJwks")
    private String jwks;
    @AttributeName(name="oxAuthSectorIdentifierURI")
    private String sectorIdentifierUri;
    @AttributeName(name="oxAuthSubjectType")
    private OxAuthSubjectType subjectType;
    @AttributeName(name="tknBndCnf")
    private String idTokenTokenBindingCnf;
    @AttributeName(name="oxRptAsJwt")
    private Boolean rptAsJwt = Boolean.FALSE;
    @AttributeName(name="oxAccessTokenAsJwt")
    private Boolean accessTokenAsJwt = Boolean.FALSE;
    @AttributeName(name="oxAccessTokenSigningAlg")
    private SignatureAlgorithm accessTokenSigningAlg;
    @AttributeName(name="oxAuthIdTokenSignedResponseAlg")
    private SignatureAlgorithm idTokenSignedResponseAlg;
    @AttributeName(name="oxAuthIdTokenEncryptedResponseAlg")
    private KeyEncryptionAlgorithm idTokenEncryptedResponseAlg;
    @AttributeName(name="oxAuthIdTokenEncryptedResponseEnc")
    private BlockEncryptionAlgorithm idTokenEncryptedResponseEnc;
    @AttributeName(name="oxAuthSignedResponseAlg")
    private SignatureAlgorithm userInfoSignedResponseAlg;
    @AttributeName(name="oxAuthUserInfoEncryptedResponseAlg")
    private KeyEncryptionAlgorithm userInfoEncryptedResponseAlg;
    @AttributeName(name="oxAuthUserInfoEncryptedResponseEnc")
    private BlockEncryptionAlgorithm userInfoEncryptedResponseEnc;
    @AttributeName(name="oxAuthRequestObjectSigningAlg")
    private SignatureAlgorithm requestObjectSigningAlg;
    @AttributeName(name="oxAuthRequestObjectEncryptionAlg")
    private KeyEncryptionAlgorithm requestObjectEncryptionAlg;
    @AttributeName(name="oxAuthRequestObjectEncryptionEnc")
    private BlockEncryptionAlgorithm requestObjectEncryptionEnc;
    @AttributeName(name="oxAuthTokenEndpointAuthMethod")
    private AuthenticationMethod tokenEndpointAuthMethod;
    @AttributeName(name="oxAuthTokenEndpointAuthSigningAlg")
    private SignatureAlgorithm tokenEndpointAuthSigningAlg;
    @AttributeName(name="oxAuthDefaultMaxAge")
    private Integer defaultMaxAge;
    @AttributeName(name="oxAuthRequireAuthTime")
    private Boolean requireAuthTime;
    @AttributeName(name="oxAuthPostLogoutRedirectURI")
    private String[] postLogoutRedirectUris;
    @AttributeName(name="oxClaimRedirectURI")
    private String[] claimRedirectURI;
    @AttributeName(name="oxAuthLogoutURI")
    private List<String> logoutUri;
    @AttributeName(name="oxAuthLogoutSessionRequired")
    private Boolean logoutSessionRequired = Boolean.FALSE;
    @AttributeName(name="oxPersistClientAuthorizations")
    private Boolean oxAuthPersistClientAuthorizations = Boolean.TRUE;
    @AttributeName(name="oxIncludeClaimsInIdToken")
    private Boolean oxIncludeClaimsInIdToken = Boolean.FALSE;
    @AttributeName(name="oxRefreshTokenLifetime")
    private Integer oxRefreshTokenLifetime;
    @AttributeName(name="oxAccessTokenLifetime")
    private Integer accessTokenLifetime;
    @AttributeName(name="oxAuthDefaultAcrValues")
    private String[] defaultAcrValues;
    @AttributeName(name="oxAuthInitiateLoginURI")
    private String initiateLoginUri;
    @AttributeName(name="oxAuthClientSecretExpiresAt")
    private Date clientSecretExpiresAt;
    @AttributeName(name="oxAuthRequestURI")
    private String[] requestUris;
    @AttributeName(name="oxAuthAuthorizedOrigins")
    private String[] authorizedOrigins;
    @AttributeName(name="oxSoftwareId")
    private String softwareId;
    @AttributeName(name="oxSoftwareVersion")
    private String softwareVersion;
    @AttributeName(name="oxSoftwareStatement")
    private String softwareStatement;
    @AttributeName(name="oxDisabled")
    private boolean disabled;
    @AttributeName(name="oxdId")
    private String oxdId;
    @Transient
    private String oxAuthClientSecret;
    @AttributeName(name="oxAttributes")
    @JsonObject
    private ClientAttributes attributes;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String[] getClaimRedirectURI() {
        return this.claimRedirectURI;
    }

    public void setClaimRedirectURI(String[] claimRedirectURI) {
        this.claimRedirectURI = claimRedirectURI;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public OxAuthApplicationType getOxAuthAppType() {
        return this.oxAuthAppType;
    }

    public void setOxAuthAppType(OxAuthApplicationType oxAuthAppType) {
        this.oxAuthAppType = oxAuthAppType;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public List<String> getOxAuthRedirectURIs() {
        return this.oxAuthRedirectURIs;
    }

    public void setOxAuthRedirectURIs(List<String> oxAuthRedirectURIs) {
        this.oxAuthRedirectURIs = oxAuthRedirectURIs;
    }

    public List<String> getOxAuthPostLogoutRedirectURIs() {
        return this.oxAuthPostLogoutRedirectURIs;
    }

    public void setOxAuthPostLogoutRedirectURIs(List<String> oxAuthPostLogoutRedirectURIs) {
        this.oxAuthPostLogoutRedirectURIs = oxAuthPostLogoutRedirectURIs;
    }

    public List<String> getOxAuthScopes() {
        return this.oxAuthScopes;
    }

    public void setOxAuthScopes(List<String> oxAuthScopes) {
        this.oxAuthScopes = oxAuthScopes;
    }

    public List<String> getOxAuthClaims() {
        return this.oxAuthClaims;
    }

    public void setOxAuthClaims(List<String> oxAuthClaims) {
        this.oxAuthClaims = oxAuthClaims;
    }

    public String getEncodedClientSecret() {
        return this.encodedClientSecret;
    }

    public void setEncodedClientSecret(String encodedClientSecret) {
        this.encodedClientSecret = encodedClientSecret;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public List<String> getAssociatedPersons() {
        return this.associatedPersons;
    }

    public void setAssociatedPersons(List<String> associatedPersons) {
        this.associatedPersons = associatedPersons;
    }

    public Boolean getOxAuthTrustedClient() {
        return this.oxAuthTrustedClient;
    }

    public void setOxAuthTrustedClient(Boolean oxAuthTrustedClient) {
        this.oxAuthTrustedClient = oxAuthTrustedClient;
    }

    public ResponseType[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(ResponseType[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public GrantType[] getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(GrantType[] grantTypes) {
        this.grantTypes = grantTypes;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public OxAuthSubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(OxAuthSubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public String getIdTokenTokenBindingCnf() {
        return this.idTokenTokenBindingCnf;
    }

    public void setIdTokenTokenBindingCnf(String idTokenTokenBindingCnf) {
        this.idTokenTokenBindingCnf = idTokenTokenBindingCnf;
    }

    public Boolean getRptAsJwt() {
        return this.rptAsJwt;
    }

    public void setRptAsJwt(Boolean rptAsJwt) {
        this.rptAsJwt = rptAsJwt;
    }

    public Boolean getAccessTokenAsJwt() {
        return this.accessTokenAsJwt;
    }

    public void setAccessTokenAsJwt(Boolean accessTokenAsJwt) {
        this.accessTokenAsJwt = accessTokenAsJwt;
    }

    public SignatureAlgorithm getAccessTokenSigningAlg() {
        return this.accessTokenSigningAlg;
    }

    public void setAccessTokenSigningAlg(SignatureAlgorithm accessTokenSigningAlg) {
        this.accessTokenSigningAlg = accessTokenSigningAlg;
    }

    public SignatureAlgorithm getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(SignatureAlgorithm idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public SignatureAlgorithm getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(SignatureAlgorithm userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public SignatureAlgorithm getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(SignatureAlgorithm requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public KeyEncryptionAlgorithm getRequestObjectEncryptionAlg() {
        return this.requestObjectEncryptionAlg;
    }

    public void setRequestObjectEncryptionAlg(KeyEncryptionAlgorithm requestObjectEncryptionAlg) {
        this.requestObjectEncryptionAlg = requestObjectEncryptionAlg;
    }

    public BlockEncryptionAlgorithm getRequestObjectEncryptionEnc() {
        return this.requestObjectEncryptionEnc;
    }

    public void setRequestObjectEncryptionEnc(BlockEncryptionAlgorithm requestObjectEncryptionEnc) {
        this.requestObjectEncryptionEnc = requestObjectEncryptionEnc;
    }

    public SignatureAlgorithm getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(SignatureAlgorithm tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public Boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public AuthenticationMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(AuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String[] getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String[] postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public List<String> getLogoutUri() {
        return this.logoutUri;
    }

    public void setLogoutUri(List<String> logoutUri) {
        this.logoutUri = logoutUri;
    }

    public Boolean getLogoutSessionRequired() {
        return this.logoutSessionRequired;
    }

    public void setLogoutSessionRequired(Boolean logoutSessionRequired) {
        this.logoutSessionRequired = logoutSessionRequired;
    }

    public Boolean getOxAuthPersistClientAuthorizations() {
        return this.oxAuthPersistClientAuthorizations;
    }

    public void setOxAuthPersistClientAuthorizations(Boolean oxAuthPersistClientAuthorizations) {
        this.oxAuthPersistClientAuthorizations = oxAuthPersistClientAuthorizations;
    }

    public Boolean getOxIncludeClaimsInIdToken() {
        return this.oxIncludeClaimsInIdToken;
    }

    public void setOxIncludeClaimsInIdToken(Boolean oxIncludeClaimsInIdToken) {
        this.oxIncludeClaimsInIdToken = oxIncludeClaimsInIdToken;
    }

    public Integer getOxRefreshTokenLifetime() {
        return this.oxRefreshTokenLifetime;
    }

    public void setOxRefreshTokenLifetime(Integer oxRefreshTokenLifetime) {
        this.oxRefreshTokenLifetime = oxRefreshTokenLifetime;
    }

    public Integer getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(Integer accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public String[] getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(String[] defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public String[] getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(String[] requestUris) {
        this.requestUris = requestUris;
    }

    public String[] getAuthorizedOrigins() {
        return this.authorizedOrigins;
    }

    public void setAuthorizedOrigins(String[] authorizedOrigins) {
        this.authorizedOrigins = authorizedOrigins;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setOxAuthClientSecret(String oxAuthClientSecret) {
        this.oxAuthClientSecret = oxAuthClientSecret;
    }

    public String getOxAuthClientSecret() {
        return this.oxAuthClientSecret;
    }

    public Date getClientSecretExpiresAt() {
        if (this.clientSecretExpiresAt == null) {
            return this.inOneCentury();
        }
        return this.clientSecretExpiresAt;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
    }

    public final String getOxdId() {
        return this.oxdId;
    }

    public final void setOxdId(String oxdId) {
        this.oxdId = oxdId;
    }

    private Date inOneCentury() {
        LocalDate nextCentury = LocalDate.now().plusYears(100L);
        return Date.from(nextCentury.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public ClientAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ClientAttributes();
        }
        return this.attributes;
    }

    public void setAttributes(ClientAttributes attributes) {
        this.attributes = attributes;
    }
}

