/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum KeyEncryptionAlgorithm implements AttributeEnum
{
    RSA1_5("RSA1_5", "RSA1_5"),
    RSA_OAEP("RSA-OAEP", "RSA-OAEP"),
    A128KW("A128KW", "A128KW"),
    A256KW("A256KW", "A256KW");

    private String value;
    private String displayName;
    private static Map<String, KeyEncryptionAlgorithm> mapByValues;

    private KeyEncryptionAlgorithm(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static KeyEncryptionAlgorithm getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return KeyEncryptionAlgorithm.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, KeyEncryptionAlgorithm>();
        for (KeyEncryptionAlgorithm enumType : KeyEncryptionAlgorithm.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

