/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.gluu.model.GluuStatus;
import org.gluu.oxtrust.model.DeconstructedTrustRelationship;
import org.gluu.oxtrust.model.GluuCustomAttribute;
import org.gluu.oxtrust.model.GluuEntityType;
import org.gluu.oxtrust.model.GluuMetadataSourceType;
import org.gluu.oxtrust.model.GluuValidationStatus;
import org.gluu.oxtrust.model.MetadataFilter;
import org.gluu.oxtrust.model.ProfileConfiguration;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.InumEntry;

@DataEntry
@ObjectClass(value="gluuSAMLconfig")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GluuSAMLTrustRelationship
extends InumEntry
implements Serializable {
    private static final long serialVersionUID = 5907443836820485369L;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    private @NotNull @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @AttributeName(name="gluuStatus")
    private GluuStatus status;
    @AttributeName(name="gluuValidationStatus")
    private GluuValidationStatus validationStatus;
    @AttributeName(name="gluuReleasedAttribute")
    private List<String> releasedAttributes;
    @NotNull
    @AttributeName(name="gluuSAMLspMetaDataSourceType")
    private GluuMetadataSourceType spMetaDataSourceType;
    @AttributeName(name="gluuSAMLspMetaDataFN")
    private String spMetaDataFN;
    @AttributeName(name="gluuSAMLspMetaDataURL")
    private String spMetaDataURL;
    @AttributeName(name="o")
    private String owner;
    @AttributeName(name="gluuSAMLmaxRefreshDelay")
    private String maxRefreshDelay;
    @Transient
    private transient List<GluuCustomAttribute> releasedCustomAttributes = new ArrayList<GluuCustomAttribute>();
    private Map<String, MetadataFilter> metadataFilters = new HashMap<String, MetadataFilter>();
    private Map<String, ProfileConfiguration> profileConfigurations = new HashMap<String, ProfileConfiguration>();
    @AttributeName(name="gluuSAMLMetaDataFilter")
    private List<String> gluuSAMLMetaDataFilter;
    @AttributeName(name="gluuTrustContact")
    private List<String> gluuTrustContact;
    private List<DeconstructedTrustRelationship> deconstructedTrustRelationships = new ArrayList<DeconstructedTrustRelationship>();
    @AttributeName(name="gluuTrustDeconstruction")
    private List<String> gluuTrustDeconstruction;
    @AttributeName(name="gluuContainerFederation")
    protected String gluuContainerFederation;
    @AttributeName(name="gluuIsFederation")
    private String gluuIsFederation;
    @AttributeName(name="gluuEntityId")
    private List<String> gluuEntityId;
    @AttributeName(name="gluuProfileConfiguration")
    private List<String> gluuProfileConfiguration;
    @AttributeName(name="gluuSpecificRelyingPartyConfig")
    private String gluuSpecificRelyingPartyConfig;
    @Pattern(regexp="^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", message="Please enter a valid SP url, including protocol (http/https)")
    @AttributeName(name="url")
    private @Pattern(regexp="^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", message="Please enter a valid SP url, including protocol (http/https)") String url;
    @Pattern(regexp="^$|(^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", message="Please enter a valid url, including protocol (http/https)")
    @AttributeName(name="oxAuthPostLogoutRedirectURI")
    private @Pattern(regexp="^$|(^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", message="Please enter a valid url, including protocol (http/https)") String spLogoutURL;
    @AttributeName(name="gluuValidationLog")
    private List<String> validationLog;
    @AttributeName(name="researchAndScholarshipEnabled")
    private String researchBundleEnabled;
    @AttributeName(name="gluuEntityType")
    private GluuEntityType entityType;

    public void setFederation(boolean isFederation) {
        this.gluuIsFederation = Boolean.toString(isFederation);
    }

    public boolean isFederation() {
        return Boolean.parseBoolean(this.gluuIsFederation);
    }

    public void setContainerFederation(GluuSAMLTrustRelationship containerFederation) {
        this.gluuContainerFederation = containerFederation.getDn();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GluuSAMLTrustRelationship)) {
            return false;
        }
        if (this.getInum() == null) {
            return this.getInum() == ((GluuSAMLTrustRelationship)o).getInum();
        }
        return this.getInum().equals(((GluuSAMLTrustRelationship)o).getInum());
    }

    public List<String> getGluuEntityId() {
        return this.gluuEntityId;
    }

    public void setGluuEntityId(Set<String> gluuEntityId) {
        this.gluuEntityId = new ArrayList<String>(gluuEntityId);
    }

    @Deprecated
    public void setGluuEntityId(List<String> gluuEntityId) {
        this.gluuEntityId = gluuEntityId;
    }

    public String getEntityId() {
        if (this.gluuEntityId != null && !this.gluuEntityId.isEmpty()) {
            return this.gluuEntityId.get(0);
        }
        return "";
    }

    public void setEntityId(String entityId) {
        TreeSet<String> entityIds = new TreeSet<String>();
        if (entityId != null) {
            entityIds.add(entityId);
        }
        this.setGluuEntityId(entityIds);
    }

    public void setSpecificRelyingPartyConfig(boolean specificRelyingPartyConfig) {
        this.gluuSpecificRelyingPartyConfig = Boolean.toString(specificRelyingPartyConfig);
    }

    public boolean getSpecificRelyingPartyConfig() {
        return Boolean.parseBoolean(this.gluuSpecificRelyingPartyConfig);
    }

    public List<DeconstructedTrustRelationship> getDeconstructedTrustRelationships() {
        return this.deconstructedTrustRelationships;
    }

    public void setDeconstructedTrustRelationships(List<DeconstructedTrustRelationship> deconstructedTrustRelationships) {
        this.deconstructedTrustRelationships = deconstructedTrustRelationships;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGluuContainerFederation() {
        return this.gluuContainerFederation;
    }

    public void setGluuContainerFederation(String gluuContainerFederation) {
        this.gluuContainerFederation = gluuContainerFederation;
    }

    public String getGluuIsFederation() {
        return this.gluuIsFederation;
    }

    public void setGluuIsFederation(String gluuIsFederation) {
        this.gluuIsFederation = gluuIsFederation;
    }

    public List<String> getGluuProfileConfiguration() {
        return this.gluuProfileConfiguration;
    }

    public void setGluuProfileConfiguration(List<String> gluuProfileConfiguration) {
        this.gluuProfileConfiguration = gluuProfileConfiguration;
    }

    public List<String> getGluuSAMLMetaDataFilter() {
        return this.gluuSAMLMetaDataFilter;
    }

    public void setGluuSAMLMetaDataFilter(List<String> gluuSAMLMetaDataFilter) {
        this.gluuSAMLMetaDataFilter = gluuSAMLMetaDataFilter;
    }

    public String getGluuSpecificRelyingPartyConfig() {
        return this.gluuSpecificRelyingPartyConfig;
    }

    public void setGluuSpecificRelyingPartyConfig(String gluuSpecificRelyingPartyConfig) {
        this.gluuSpecificRelyingPartyConfig = gluuSpecificRelyingPartyConfig;
    }

    public List<String> getGluuTrustContact() {
        return this.gluuTrustContact;
    }

    public void setGluuTrustContact(List<String> gluuTrustContact) {
        this.gluuTrustContact = gluuTrustContact;
    }

    public List<String> getGluuTrustDeconstruction() {
        return this.gluuTrustDeconstruction;
    }

    public void setGluuTrustDeconstruction(List<String> gluuTrustDeconstruction) {
        this.gluuTrustDeconstruction = gluuTrustDeconstruction;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    public void setMaxRefreshDelay(String maxRefreshDelay) {
        this.maxRefreshDelay = maxRefreshDelay;
    }

    public Map<String, MetadataFilter> getMetadataFilters() {
        return this.metadataFilters;
    }

    public void setMetadataFilters(Map<String, MetadataFilter> metadataFilters) {
        this.metadataFilters = metadataFilters;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Map<String, ProfileConfiguration> getProfileConfigurations() {
        return this.profileConfigurations;
    }

    public void setProfileConfigurations(Map<String, ProfileConfiguration> profileConfigurations) {
        this.profileConfigurations = profileConfigurations;
    }

    public List<String> getReleasedAttributes() {
        return this.releasedAttributes;
    }

    public void setReleasedAttributes(List<String> releasedAttributes) {
        this.releasedAttributes = releasedAttributes;
    }

    public List<GluuCustomAttribute> getReleasedCustomAttributes() {
        return this.releasedCustomAttributes;
    }

    public void setReleasedCustomAttributes(List<GluuCustomAttribute> releasedCustomAttributes) {
        this.releasedCustomAttributes = releasedCustomAttributes;
    }

    public String getSpLogoutURL() {
        return this.spLogoutURL;
    }

    public void setSpLogoutURL(String spLogoutURL) {
        this.spLogoutURL = spLogoutURL;
    }

    public String getSpMetaDataFN() {
        return this.spMetaDataFN;
    }

    public void setSpMetaDataFN(String spMetaDataFN) {
        this.spMetaDataFN = spMetaDataFN;
    }

    public GluuMetadataSourceType getSpMetaDataSourceType() {
        return this.spMetaDataSourceType;
    }

    public void setSpMetaDataSourceType(GluuMetadataSourceType spMetaDataSourceType) {
        this.spMetaDataSourceType = spMetaDataSourceType;
    }

    public String getSpMetaDataURL() {
        return this.spMetaDataURL;
    }

    public void setSpMetaDataURL(String spMetaDataURL) {
        this.spMetaDataURL = spMetaDataURL;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getValidationLog() {
        return this.validationLog;
    }

    public void setValidationLog(List<String> validationLog) {
        this.validationLog = validationLog;
    }

    public GluuValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(GluuValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public String getResearchBundleEnabled() {
        return this.researchBundleEnabled;
    }

    public void setResearchBundleEnabled(String researchBundleEnabled) {
        this.researchBundleEnabled = researchBundleEnabled;
    }

    public boolean isResearchBundle() {
        return Boolean.parseBoolean(this.researchBundleEnabled);
    }

    public boolean getResearchBundle() {
        return Boolean.parseBoolean(this.researchBundleEnabled);
    }

    public void setResearchBundle(boolean researchBundle) {
        this.researchBundleEnabled = Boolean.toString(researchBundle);
    }

    public GluuEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(GluuEntityType entityType) {
        this.entityType = entityType;
    }
}

