/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum GluuMetadataSourceType implements AttributeEnum
{
    NONE("none", "None"),
    FILE("file", "File"),
    URI("uri", "URI"),
    FEDERATION("federation", "Federation");

    private final String value;
    private final String displayName;
    private static final Map<String, GluuMetadataSourceType> mapByValues;

    private GluuMetadataSourceType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static GluuMetadataSourceType getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return GluuMetadataSourceType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, GluuMetadataSourceType>();
        for (GluuMetadataSourceType enumType : GluuMetadataSourceType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

