/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gluu.model.GluuStatus;
import org.gluu.oxtrust.model.GluuCustomAttribute;
import org.gluu.oxtrust.model.GluuGroupVisibility;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.AttributesList;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.Entry;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="gluuGroup")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GluuGroup
extends Entry
implements Serializable {
    private static final long serialVersionUID = -2812480357430436503L;
    private transient boolean selected;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    private @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @NotNull
    @AttributeName
    private String owner;
    @AttributeName(name="member")
    private List<String> members = new ArrayList<String>();
    @AttributeName(name="c")
    private String countryName;
    @AttributeName(name="o")
    private String organization;
    @AttributeName
    private String seeAlso;
    @AttributeName(name="gluuStatus")
    private GluuStatus status;
    @AttributeName(name="gluuGroupVisibility")
    private GluuGroupVisibility visibility;
    @AttributesList(name="name", value="values", sortByName=true, attributesConfiguration={@AttributeName(name="inum", ignoreDuringUpdate=true)})
    private List<GluuCustomAttribute> customAttributes = new ArrayList<GluuCustomAttribute>();

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public GluuGroupVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(GluuGroupVisibility visibility) {
        this.visibility = visibility;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return String.format("GluuGroup [countryName=%s, description=%s, displayName=%s,  inum=%s, members=%s, organization=%s, owner=%s, seeAlso=%s, status=%s, visibility=%s, toString()=%s]", new Object[]{this.countryName, this.description, this.displayName, this.inum, this.members, this.organization, this.owner, this.seeAlso, this.status, this.visibility, super.toString()});
    }

    public List<GluuCustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<GluuCustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String attributeName) {
        String value = null;
        for (GluuCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public String[] getAttributeArray(String attributeName) {
        GluuCustomAttribute gluuCustomAttribute = this.getGluuCustomAttribute(attributeName);
        if (gluuCustomAttribute == null) {
            return null;
        }
        return gluuCustomAttribute.getValues();
    }

    public GluuCustomAttribute getGluuCustomAttribute(String attributeName) {
        for (GluuCustomAttribute gluuCustomAttribute : this.customAttributes) {
            if (!gluuCustomAttribute.getName().equalsIgnoreCase(attributeName)) continue;
            return gluuCustomAttribute;
        }
        return null;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        GluuCustomAttribute attribute = new GluuCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }

    public void setAttribute(String attributeName, String[] attributeValue) {
        GluuCustomAttribute attribute = new GluuCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }
}

