/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.gluu.model.GluuStatus;
import org.gluu.oxtrust.model.GluuCustomAttribute;
import org.gluu.oxtrust.model.OTPDevice;
import org.gluu.oxtrust.model.User;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="gluuPerson")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GluuCustomPerson
extends User
implements Serializable {
    private static final long serialVersionUID = -1879582184398161112L;
    private transient boolean selected;
    private String sourceServerName;
    private String sourceServerUserDn;
    @AttributeName(name="gluuWhitePagesListed")
    private String gluuAllowPublication;
    @AttributeName(name="oxGuid")
    private String guid;
    @AttributeName(name="gluuOptOuts")
    private List<String> gluuOptOuts;
    @AttributeName(name="associatedClient")
    private List<String> associatedClient;
    @AttributeName(name="oxPPID")
    private List<String> oxPPID;
    @AttributeName(name="oxExternalUid")
    private List<String> oxExternalUid;
    @JsonObject
    @AttributeName(name="oxOTPDevices")
    private OTPDevice oxOTPDevices;
    @AttributeName(name="oxMobileDevices")
    private String oxMobileDevices;
    @AttributeName(name="oxCreationTimestamp")
    private Date creationDate;
    @AttributeName
    private Date updatedAt;

    public String getOxMobileDevices() {
        return this.oxMobileDevices;
    }

    public void setOxMobileDevices(String oxMobileDevices) {
        this.oxMobileDevices = oxMobileDevices;
    }

    public OTPDevice getOxOTPDevices() {
        return this.oxOTPDevices;
    }

    public void setOxOTPDevices(OTPDevice oxOTPDevices) {
        this.oxOTPDevices = oxOTPDevices;
    }

    public String getMail() {
        return this.getAttribute("mail");
    }

    public void setMail(String value) {
        this.setAttribute("mail", value);
    }

    public String getGluuIMAPData() {
        return this.getAttribute("gluuIMAPData");
    }

    public void setGluuIMAPData(String value) {
        this.setAttribute("gluuIMAPData", value);
    }

    public String getNetworkPoken() {
        return this.getAttribute("networkPoken");
    }

    public void setNetworkPoken(String value) {
        this.setAttribute("networkPoken", value);
    }

    public String getCommonName() {
        return this.getAttribute("cn");
    }

    public void setCommonName(String value) {
        this.setAttribute("cn", value);
    }

    public String getGivenName() {
        return this.getAttribute("givenName");
    }

    public void setGivenName(String value) {
        this.setAttribute("givenName", value);
    }

    public GluuStatus getStatus() {
        return GluuStatus.getByValue((String)this.getAttribute("gluuStatus"));
    }

    public void setStatus(GluuStatus value) {
        this.setAttribute("gluuStatus", value.getValue());
    }

    public String getUserPassword() {
        return this.getAttribute("userPassword");
    }

    public void setUserPassword(String value) {
        this.setAttribute("userPassword", value);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Boolean getSLAManager() {
        return Boolean.valueOf(this.getAttribute("gluuSLAManager"));
    }

    public void setSLAManager(Boolean value) {
        this.setAttribute("gluuSLAManager", value.toString());
    }

    public List<String> getMemberOf() {
        String[] value = new String[]{};
        for (GluuCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase("memberOf")) continue;
            value = attribute.getValues();
            break;
        }
        return Arrays.asList(value);
    }

    public void setMemberOf(List<String> value) {
        this.setAttribute("memberOf", value.toArray(new String[0]));
    }

    public String getSurname() {
        return this.getAttribute("sn");
    }

    public void setSurname(String value) {
        this.setAttribute("sn", value);
    }

    public void setTimezone(String value) {
        this.setAttribute("zoneinfo", value);
    }

    public String getTimezone() {
        return this.getAttribute("zoneinfo");
    }

    public void setPreferredLanguage(String value) {
        this.setAttribute("preferredLanguage", value);
    }

    public String getPreferredLanguage() {
        return this.getAttribute("preferredLanguage");
    }

    public int getAttributeIndex(String attributeName) {
        int idx = 0;
        for (GluuCustomAttribute attribute : this.customAttributes) {
            if (attribute.getName().equalsIgnoreCase(attributeName)) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }

    @Override
    public String getAttribute(String attributeName) {
        String value = null;
        for (GluuCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public String[] getAttributeArray(String attributeName) {
        GluuCustomAttribute gluuCustomAttribute = this.getGluuCustomAttribute(attributeName);
        if (gluuCustomAttribute == null) {
            return null;
        }
        return gluuCustomAttribute.getValues();
    }

    public GluuCustomAttribute getGluuCustomAttribute(String attributeName) {
        for (GluuCustomAttribute gluuCustomAttribute : this.customAttributes) {
            if (!gluuCustomAttribute.getName().equalsIgnoreCase(attributeName)) continue;
            return gluuCustomAttribute;
        }
        return null;
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        GluuCustomAttribute attribute = new GluuCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }

    @Override
    public void setAttribute(String attributeName, String[] attributeValue) {
        GluuCustomAttribute attribute = new GluuCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }

    public void removeAttribute(String attributeName) {
        Iterator it = this.customAttributes.iterator();
        while (it.hasNext()) {
            GluuCustomAttribute attribute = (GluuCustomAttribute)it.next();
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public void setGluuAllowPublication(String allowPublication) {
        this.gluuAllowPublication = allowPublication;
    }

    public String getGluuAllowPublication() {
        return this.gluuAllowPublication;
    }

    public boolean isAllowPublication() {
        return Boolean.parseBoolean(this.gluuAllowPublication);
    }

    public void setAllowPublication(boolean allowPublication) {
        this.gluuAllowPublication = Boolean.toString(allowPublication);
    }

    public void setGluuOptOuts(List<String> optOuts) {
        this.gluuOptOuts = optOuts;
    }

    public List<String> getGluuOptOuts() {
        return this.gluuOptOuts;
    }

    public List<String> getAssociatedClient() {
        return this.associatedClient;
    }

    public void setAssociatedClient(List<String> associatedClientDNs) {
        this.associatedClient = associatedClientDNs;
    }

    public String getSourceServerName() {
        return this.sourceServerName;
    }

    public void setSourceServerName(String sourceServerName) {
        this.sourceServerName = sourceServerName;
    }

    public final String getSourceServerUserDn() {
        return this.sourceServerUserDn;
    }

    public final void setSourceServerUserDn(String sourceServerUserDn) {
        this.sourceServerUserDn = sourceServerUserDn;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public List<String> getOxExternalUid() {
        return this.oxExternalUid;
    }

    public void setOxExternalUid(List<String> oxExternalUid) {
        this.oxExternalUid = oxExternalUid;
    }

    public List<String> getOxPPID() {
        return this.oxPPID;
    }

    public void setOxPPID(List<String> oxPPID) {
        this.oxPPID = oxPPID;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && this.getInum() != null && obj instanceof GluuCustomPerson) {
            result = this.getInum().equals(((GluuCustomPerson)obj).getInum());
        }
        return result;
    }

    public GluuCustomPerson clone() throws CloneNotSupportedException {
        return (GluuCustomPerson)super.clone();
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }
}

