/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.gluu.model.GluuAttribute;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.persist.model.base.GluuBoolean;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={GluuAttribute.class})
public class GluuCustomAttribute
implements Serializable,
Comparable<GluuCustomAttribute> {
    private static final long serialVersionUID = 1468440094325406153L;
    private String name;
    private String[] values;
    private transient GluuAttribute metadata;
    private transient boolean newAttribute = false;
    private transient boolean mandatory = false;
    private transient boolean readonly = false;
    private transient GluuBoolean[] booleanValues;
    private transient boolean usedBooleanValues = false;
    Map<String[], String> idComponentMap = new HashMap<String[], String>();

    public GluuCustomAttribute() {
    }

    public GluuCustomAttribute(String name, String value) {
        this.name = name;
        this.setValue(value);
    }

    public GluuCustomAttribute(String name, String value, boolean newAttribute) {
        this.name = name;
        this.setValue(value);
        this.newAttribute = newAttribute;
    }

    public GluuCustomAttribute(String name, String value, boolean newAttribute, boolean mandatory) {
        this.name = name;
        this.setValue(value);
        this.newAttribute = newAttribute;
        this.mandatory = mandatory;
    }

    public GluuCustomAttribute(String name, String[] values, boolean newAttribute, boolean mandatory) {
        this.name = name;
        this.values = values;
        this.newAttribute = newAttribute;
        this.mandatory = mandatory;
    }

    public GluuCustomAttribute(String name, String[] values) {
        this.name = name;
        this.values = values;
    }

    public GluuCustomAttribute(String name, Set<String> values) {
        this.name = name;
        this.values = values.toArray(new String[0]);
    }

    public String getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public void setValue(String value) {
        if (this.values == null) {
            this.values = new String[0];
        }
        if (this.values.length != 1) {
            this.values = new String[1];
        }
        this.values[0] = value;
    }

    public GluuBoolean getBooleanValue() {
        if (this.booleanValues == null) {
            return null;
        }
        if (this.booleanValues.length > 0) {
            return this.booleanValues[0];
        }
        return null;
    }

    public void setBooleanValue(GluuBoolean value) {
        if (this.booleanValues == null) {
            this.booleanValues = new GluuBoolean[0];
        }
        if (this.booleanValues.length != 1) {
            this.booleanValues = new GluuBoolean[1];
        }
        this.booleanValues[0] = value;
    }

    public String[] getValues() {
        if (this.metadata != null && AttributeDataType.BOOLEAN == this.metadata.getDataType() && this.usedBooleanValues) {
            this.values = this.toStringValuesFromBooleanValues(this.booleanValues);
        }
        return this.values;
    }

    public GluuBoolean[] getBooleanValues() {
        this.usedBooleanValues = true;
        return this.booleanValues;
    }

    public void setBooleanValues(GluuBoolean[] booleanValues) {
        this.usedBooleanValues = true;
        this.booleanValues = booleanValues;
    }

    @JsonIgnore
    @XmlTransient
    public void setValues(String[] values) {
        this.values = values;
    }

    public void setValues(Collection<String> values) {
        this.values = values.toArray(new String[0]);
    }

    @JsonIgnore
    @XmlTransient
    public void setValues(Set<String> values) {
        this.values = values.toArray(new String[0]);
    }

    public boolean isNew() {
        return this.newAttribute;
    }

    public void setNew(boolean newAttribute) {
        this.newAttribute = newAttribute;
    }

    public String getDisplayValue() {
        if (this.values == null || this.values.length == 0) {
            return "";
        }
        if (this.values.length == 1) {
            return this.values[0];
        }
        StringBuilder sb = new StringBuilder(this.values[0]);
        for (int i = 1; i < this.values.length; ++i) {
            sb.append(", ").append(this.values[i]);
        }
        return sb.toString();
    }

    public boolean isAdminCanAccess() {
        return this.metadata != null && this.metadata.isAdminCanAccess();
    }

    public boolean isAdminCanView() {
        return this.metadata != null && this.metadata.isAdminCanView();
    }

    public boolean isAdminCanEdit() {
        return this.metadata != null && this.metadata.isAdminCanEdit();
    }

    public boolean isUserCanAccess() {
        return this.metadata != null && this.metadata.isUserCanAccess();
    }

    public boolean isUserCanView() {
        return this.metadata != null && this.metadata.isUserCanView();
    }

    public boolean isUserCanEdit() {
        return this.metadata != null && this.metadata.isUserCanEdit();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GluuAttribute getMetadata() {
        return this.metadata;
    }

    public void setMetadata(GluuAttribute metadata) {
        this.metadata = metadata;
        if (this.metadata != null && AttributeDataType.BOOLEAN == this.metadata.getDataType()) {
            this.booleanValues = this.toBooleanValuesFromStringValues(this.values);
        }
    }

    public boolean isNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(boolean newAttribute) {
        this.newAttribute = newAttribute;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GluuCustomAttribute that = (GluuCustomAttribute)o;
        return !(this.name == null ? that.name != null : !this.name.equalsIgnoreCase(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("Attribute [name=%s, values=%s, metadata=%s]", this.name, Arrays.toString(this.values), this.metadata);
    }

    @Override
    public int compareTo(GluuCustomAttribute o) {
        return this.name.compareTo(o.name);
    }

    private GluuBoolean[] toBooleanValuesFromStringValues(String[] inputValues) {
        if (inputValues == null) {
            return null;
        }
        GluuBoolean[] resultValues = new GluuBoolean[inputValues.length];
        for (int i = 0; i < inputValues.length; ++i) {
            resultValues[i] = this.toBooleanFromString(inputValues[i]);
        }
        return resultValues;
    }

    private String[] toStringValuesFromBooleanValues(GluuBoolean[] inputValues) {
        if (inputValues == null) {
            return null;
        }
        String[] resultValues = new String[inputValues.length];
        for (int i = 0; i < inputValues.length; ++i) {
            resultValues[i] = this.toStringFromBoolean(inputValues[i]);
        }
        return resultValues;
    }

    protected GluuBoolean toBooleanFromString(String value) {
        if (value == null) {
            return null;
        }
        return GluuBoolean.getByValue((String)value);
    }

    protected String toStringFromBoolean(GluuBoolean value) {
        if (value == null) {
            return null;
        }
        return value.getValue();
    }
}

