/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.gluu.oxtrust.model.GluuCustomAttribute;
import org.gluu.persist.annotation.CustomObjectClass;
import org.gluu.persist.model.base.Entry;
import org.gluu.util.StringHelper;

public abstract class CustomEntry
extends Entry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5079582184398161111L;
    @CustomObjectClass
    private String[] customObjectClasses;

    public abstract List<GluuCustomAttribute> getCustomAttributes();

    public abstract void setCustomAttributes(List<GluuCustomAttribute> var1);

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }

    public String[] getAttributes(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        String[] values = null;
        for (GluuCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            values = attribute.getValues();
            break;
        }
        return values;
    }

    public String getAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        String value = null;
        for (GluuCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = this.getAttribute(attributeName);
        if (StringHelper.isEmpty((String)result)) {
            result = defaultValue;
        }
        return result;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.setAttribute(new GluuCustomAttribute(attributeName, attributeValue));
    }

    public void setAttribute(String attributeName, String[] attributeValue) {
        this.setAttribute(new GluuCustomAttribute(attributeName, attributeValue));
    }

    public void setAttribute(GluuCustomAttribute attribute) {
        List<GluuCustomAttribute> customAttributes = this.getCustomAttributes();
        customAttributes.remove(attribute);
        customAttributes.add(attribute);
    }

    public String toString() {
        return String.format("CustomEntry [customAttributes=%s, customObjectClasses=%s, toString()=%s]", this.getCustomAttributes(), Arrays.toString(this.customObjectClasses), super.toString());
    }
}

