/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model;

import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum AuthenticationMethod implements AttributeEnum
{
    CLIENT_SECRET_BASIC("client_secret_basic", "client_secret_basic"),
    CLIENT_SECRET_POST("client_secret_post", "client_secret_post"),
    CLIENT_SECRET_JWT("client_secret_jwt", "client_secret_jwt"),
    PRIVATE_KEY_JWT("private_key_jwt", "private_key_jwt"),
    NONE("none", "none");

    private String value;
    private String displayName;
    private static Map<String, AuthenticationMethod> mapByValues;

    private AuthenticationMethod(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static AuthenticationMethod getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return AuthenticationMethod.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, AuthenticationMethod>();
        for (AuthenticationMethod enumType : AuthenticationMethod.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

