/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxnotify.client;

import java.util.Base64;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.gluu.oxnotify.client.NotifyClientService;
import org.gluu.oxnotify.client.NotifyMetadataClientService;
import org.gluu.oxnotify.model.NotifyMetadata;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class NotifyClientFactory {
    private static final NotifyClientFactory instance = new NotifyClientFactory();
    private ResteasyClient client = (ResteasyClient)ResteasyClientBuilder.newClient();
    private ResteasyClient pooledClient;

    private NotifyClientFactory() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        this.pooledClient = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)engine).build();
    }

    public static NotifyClientFactory instance() {
        return instance;
    }

    public NotifyMetadataClientService createMetaDataConfigurationService(String issuer) {
        ResteasyWebTarget target = this.client.target(UriBuilder.fromPath((String)(issuer + "/.well-known/notify-configuration")));
        return (NotifyMetadataClientService)target.proxy(NotifyMetadataClientService.class);
    }

    public NotifyClientService createNotifyService(NotifyMetadata notifyMetadata) {
        ResteasyWebTarget target = this.pooledClient.target(UriBuilder.fromPath((String)notifyMetadata.getNotifyEndpoint()));
        return (NotifyClientService)target.proxy(NotifyClientService.class);
    }

    public static String getAuthorization(String accessKeyId, String secretAccessKey) {
        String credentials = accessKeyId + ":" + secretAccessKey;
        String authorization = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
        return authorization;
    }
}

