package org.gluu.oxd.license.client.js;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Yuriy Zabrovarnyy
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AppMetadata {

    @JsonProperty(value = "app_name")
    private String appName;
    @JsonProperty(value = "app_version")
    private String appVersion;
    @JsonProperty(value = "programming_language")
    private String programmingLanguage;
    @JsonProperty(value = "data")
    private Map<String, String> data = new HashMap<>();

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppVersion() {
        return appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getProgrammingLanguage() {
        return programmingLanguage;
    }

    public void setProgrammingLanguage(String programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
    }

    public Map<String, String> getData() {
        return data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "AppMetadata{" +
                "appName='" + appName + '\'' +
                ", appVersiom='" + appVersion + '\'' +
                ", programmingLanguage='" + programmingLanguage + '\'' +
                ", data=" + data +
                '}';
    }
}
