package org.gluu.oxd.license.client.js;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;
import java.util.Date;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 18/10/2016
 */

public class UnixTimestampDeserializer extends JsonDeserializer<Date> {
    private final static Logger LOG = LogManager.getLogger(UnixTimestampDeserializer.class);

    @Override
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String date = jp.getText().trim();

        try {
            if (date.length() == 10) {
                date = date + "000";
            }
            return new Date(Long.valueOf(date));
        } catch (Exception e) {
            LOG.error("Unable to deserialize date: " + date, e);
            return null;
        }
    }
}