package org.gluu.oxd.license.client.js;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Yuriy Zabrovarnyy
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class InfoMacAddressRequest implements Serializable {

    @JsonProperty(value = "licenseId")
    private String licenseId;
    @JsonProperty(value = "macAddresses")
    private List<String> macAddresses = new ArrayList<>();

    public String getLicenseId() {
        return licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public List<String> getMacAddresses() {
        return macAddresses;
    }

    public void setMacAddresses(List<String> macAddresses) {
        this.macAddresses = macAddresses;
    }

    @Override
    public String toString() {
        return "InfoMacAddressRequest{" +
                "licenseId='" + licenseId + '\'' +
                ", macAddresses=" + macAddresses +
                '}';
    }
}
