package org.gluu.oxd.license.client.js.event;

import java.io.Serializable;
import java.util.Date;

import org.gluu.oxd.license.client.js.HasCreationDate;
import org.gluu.oxd.license.client.js.UnixTimestampDeserializer;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Yuriy Zabrovarnyy
 */
@DataEntry
@ObjectClass(values = {"top", "oxLicenseIdStatistic"})
public class LdapLicenseGeneratedEvent implements Serializable, HasCreationDate {

    @DN
    private String dn;
    @AttributeName(name = "uniqueIdentifier")
    private String id;
    @JsonDeserialize(using = UnixTimestampDeserializer.class)
    @AttributeName(name = "oxCreationDate")
    private Date creationDate;
    @AttributeName(name = "oxMacAddress")
    private String macAddress;

    public String getDn() {
        return dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Override
    public String toString() {
        return "LdapLicenseGeneratedEvent{" +
                "dn='" + dn + '\'' +
                ", id='" + id + '\'' +
                ", creationDate=" + creationDate +
                ", macAddress='" + macAddress + '\'' +
                '}';
    }
}
