package org.gluu.oxd.license.client.js.event;

import java.io.Serializable;
import java.util.Date;

import org.gluu.oxd.license.client.js.HasCreationDate;
import org.gluu.oxd.license.client.js.UnixTimestampDeserializer;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 06/09/2016
 */

import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@DataEntry
@ObjectClass(values = {"top", "oxLicenseClientEvent"})
public class LdapClientEvent implements Serializable, HasCreationDate {

    @DN
    private String dn;
    @AttributeName(name = "uniqueIdentifier")
    private String id;
    @JsonDeserialize(using = UnixTimestampDeserializer.class)
    @AttributeName(name = "oxCreationDate")
    private Date creationDate;
    @AttributeName(name = "oxMacAddress")
    private String macAddress;
    @AttributeName(name = "oxLicenseClientName")
    private String clientName;
    @AttributeName(name = "oxLicenseClientId")
    private String clientId;
    @AttributeName(name = "oxdId")
    private String oxdId;
    @AttributeName(name = "oxLicenseIsClientLocal")
    private Boolean clientLocal;
    @AttributeName(name = "oxLicenseAppMetadata")
    private String appMetadata;

    public String getAppMetadata() {
        return appMetadata;
    }

    public void setAppMetadata(String appMetadata) {
        this.appMetadata = appMetadata;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getOxdId() {
        return oxdId;
    }

    public void setOxdId(String oxdId) {
        this.oxdId = oxdId;
    }

    public String getDn() {
        return dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public Boolean getClientLocal() {
        return clientLocal != null ? clientLocal : false;
    }

    public void setClientLocal(Boolean clientLocal) {
        this.clientLocal = clientLocal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LdapClientEvent that = (LdapClientEvent) o;

        return !(id != null ? !id.equals(that.id) : that.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "LdapLicenseIdStatistic{" +
                "dn='" + dn + '\'' +
                ", id='" + id + '\'' +
                ", creationDate=" + creationDate +
                ", macAddress='" + macAddress + '\'' +
                ", clientName='" + clientName + '\'' +
                ", clientId='" + clientId + '\'' +
                ", oxdId='" + oxdId + '\'' +
                ", appMetadata='" + appMetadata + '\'' +
                '}';
    }
}
