package org.gluu.oxd.license.client.js;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 19/08/2016
 */

public enum Product {
    OXD("oxd"),
    CLUSTER_MANAGER("cluster_manager"),
    API_GATEWAY("api_gateway"),
    SUPER_GLUU("super_gluu");

    private final String value;

    private Product(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static Product fromValue(String value) {
        for (Product product : values()) {
            if (product.getValue().equals(value)) {
                return product;
            }
        }
        return null;
    }

    public static String supportedProductsString() {
        String result = "";
        for (Product product : Product.values()) {
            result += product.getValue() + " ";
        }
        return result.trim();
    }

    public static List<Product> getProducts(LicenseMetadata metadata) {
        List<Product> result = new ArrayList<>();
        final Product product = fromValue(metadata.getProduct());
        if (product != null) {
            result.add(product);
        }
        if (metadata.getProducts() != null && !metadata.getProducts().isEmpty()) {
            for (String p : metadata.getProducts()) {
                final Product parsedProduct = fromValue(p);
                if (parsedProduct != null) {
                    result.add(parsedProduct);
                }
            }
        }
        return result;
    }

    public static String getProductsAsString(LicenseMetadata metadata) {
        return asString(getProducts(metadata));
    }

    public static String asString(List<Product> products) {
        String s = "";
        for (Product p : products) {
            s = s + p.getValue() + " ";
        }
        return s.trim();
    }
}
