package org.gluu.oxd.license.client.js;

import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;

import java.io.Serializable;
import java.util.List;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 30/09/2014
 */

@DataEntry
@ObjectClass(values = {"top", "oxLicenseId"})
public class LdapLicenseId implements Serializable {

    @DN
    private String dn;
    @AttributeName(name = "licenseId")
    private String licenseId;
    @AttributeName(name = "oxLicenseMetadata")
    private String metadata;
    @AttributeName(name = "oxLicense")
    private List<String> licenses;
    @AttributeName(name = "oxLicenseCrypt")
    private String licenseCryptDN;

    private LicenseMetadata metadataAsObject;

    public LicenseMetadata getMetadataAsObject() {
        return metadataAsObject;
    }

    public void setMetadataAsObject(LicenseMetadata metadataAsObject) {
        this.metadataAsObject = metadataAsObject;
    }

    public String getLicenseCryptDN() {
        return licenseCryptDN;
    }

    public void setLicenseCryptDN(String licenseCryptDN) {
        this.licenseCryptDN = licenseCryptDN;
    }

    public String getDn() {
        return dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getLicenseId() {
        return licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public List<String> getLicenses() {
        return licenses;
    }

    public void setLicenses(List<String> licenses) {
        this.licenses = licenses;
    }

    public String getMetadata() {
        return metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }
}
