/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.license.test;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.license.test.TestAppModule;
import org.gluu.oxd.licenser.server.service.LicenseCryptService;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.gluu.oxd.licenser.server.ws.MetadataWS;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestAppModule.class})
public class MetadataWsTest {
    @Inject
    LicenseCryptService licenseCryptService;
    @Inject
    MetadataWS metadataWS;
    @Inject
    LicenseIdService licenseIdService;
    private LdapLicenseId licenseId;
    private Date expirationDate;

    @BeforeClass
    public void setUp() {
        LicenseMetadata metadata = new LicenseMetadata();
        metadata.setProducts((List)Lists.newArrayList((Object[])new String[]{"oxd"}));
        metadata.setLicenseName("Test name");
        metadata.setLicenseCountLimit(4);
        this.expirationDate = new Date();
        metadata.setExpirationDate(this.expirationDate);
        LdapLicenseCrypt crypt = this.licenseCryptService.generate();
        this.licenseCryptService.save(crypt);
        this.licenseId = this.licenseIdService.generate(crypt.getDn(), metadata);
        this.licenseIdService.save(this.licenseId);
    }

    @Test
    public void metadata() throws IOException {
        LicenseMetadata metadata = this.metadataWS.metadata(this.licenseId.getLicenseId());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((String)metadata.getLicenseName(), (String)"Test name");
        Assert.assertEquals((Object)metadata.getExpirationDate(), (Object)this.expirationDate);
    }

    @Test(expectedExceptions={WebApplicationException.class})
    public void invalidLicenseId() throws IOException {
        this.metadataWS.metadata("bla-bla");
    }
}

