/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.ws;

import com.google.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxd.license.client.js.StatisticUpdateRequest;
import org.gluu.oxd.licenser.server.service.ErrorService;
import org.gluu.oxd.licenser.server.service.LicenseGeneratedStatService;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.service.StatisticUpdator;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest/statistic")
public class StatisticWS {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticWS.class);
    @Inject
    ValidationService validationService;
    @Inject
    ErrorService errorService;
    @Inject
    StatisticService statisticService;
    @Inject
    StatisticUpdator statisticUpdator;
    @Inject
    LicenseGeneratedStatService licenseGeneratedStatService;

    @POST
    @Path(value="/update")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(StatisticUpdateRequest request) {
        try {
            this.statisticUpdator.update(request);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(ErrorService.response(e.getMessage()));
        }
    }

    @GET
    @Path(value="/monthly")
    @Produces(value={"application/json"})
    public Response licenseGeneratedMonthly(@QueryParam(value="licenseId") String licenseId) {
        LOG.debug("License generated monthly request, licenseId: " + licenseId);
        return this.okWithCors(this.licenseGeneratedStatService.monthlyStatistic(licenseId));
    }

    @GET
    @Path(value="/lastHours")
    @Produces(value={"application/json"})
    public Response licenseGeneratedLastHours(@QueryParam(value="licenseId") String licenseId, @QueryParam(value="hours") int hours) {
        LOG.debug("License generated last hours request, licenseId: " + licenseId + ", hours: " + hours);
        return this.okWithCors(this.licenseGeneratedStatService.lastHours(licenseId, hours));
    }

    @GET
    @Path(value="/client/monthly")
    @Produces(value={"application/json"})
    public Response clientMonthly(@QueryParam(value="licenseId") String licenseId) {
        LOG.debug("Client monthly request, licenseId: " + licenseId);
        return this.okWithCors(this.statisticService.clientMonthlyStatistic(licenseId));
    }

    @GET
    @Path(value="/client/lastHours")
    @Produces(value={"application/json"})
    public Response clientEventLastHours(@QueryParam(value="licenseId") String licenseId, @QueryParam(value="hours") int hours) {
        LOG.debug("Client event last hours request, licenseId: " + licenseId + ", hours: " + hours);
        return this.okWithCors(this.statisticService.lastHoursLicenseIdStatistic(licenseId, hours));
    }

    private Response okWithCors(String entity) {
        Response.ResponseBuilder builder = Response.ok().entity((Object)entity);
        builder.header("Access-Control-Allow-Origin", (Object)"*");
        builder.header("Access-Control-Allow-Methods", (Object)"GET");
        return builder.build();
    }
}

