/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.ws;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.data.LicenseResponse;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseIdItem;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.license.client.js.event.LdapLicenseGeneratedEvent;
import org.gluu.oxd.licenser.server.LicenseGenerator;
import org.gluu.oxd.licenser.server.LicenseGeneratorInput;
import org.gluu.oxd.licenser.server.service.ErrorService;
import org.gluu.oxd.licenser.server.service.LicenseCryptService;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest")
public class GenerateLicenseWS {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateLicenseWS.class);
    @Inject
    LicenseGenerator licenseGenerator;
    @Inject
    LicenseIdService licenseIdService;
    @Inject
    LicenseCryptService licenseCryptService;
    @Inject
    ValidationService validationService;
    @Inject
    StatisticService statisticService;

    public LicenseResponse generateLicense(String licenseIdStr, String macAddress) {
        try {
            LdapLicenseId licenseId = this.validationService.getLicenseId(licenseIdStr);
            LdapLicenseCrypt licenseCrypt = this.getLicenseCrypt(licenseId.getLicenseCryptDN(), licenseIdStr);
            LicenseMetadata metadata = (LicenseMetadata)Jackson.createJsonMapper().readValue(licenseId.getMetadata(), LicenseMetadata.class);
            if (!metadata.getAutoupdate().booleanValue()) {
                LOG.warn("Client application is generating license with autoupdate=false. " + licenseIdStr + ", macAddress:" + macAddress);
            }
            if (metadata.getActive() == null || !metadata.getActive().booleanValue()) {
                throw new WebApplicationException(ErrorService.response("License ID is NOT active."));
            }
            int createdLicensesTillNow = this.statisticService.getAll(licenseIdStr).size();
            if (createdLicensesTillNow >= metadata.getLicenseCountLimit()) {
                LOG.debug("License ID count limit exceeded, licenseId: " + licenseIdStr);
                throw new WebApplicationException(ErrorService.response("License ID count limit exceeded."));
            }
            Date now = new Date();
            Date expiredAt = metadata.getExpirationDate() != null ? metadata.getExpirationDate() : GenerateLicenseWS.plus30DayFromNow();
            if (!now.before(expiredAt)) {
                LOG.debug("License ID is expired, licenseId: " + licenseIdStr + ", expiredAt: " + expiredAt + ", now: " + now);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"License ID expires.").build());
            }
            LicenseGeneratorInput input = new LicenseGeneratorInput();
            input.setCreatedAt(now);
            input.setExpiredAt(expiredAt);
            input.setCrypt(licenseCrypt);
            input.setMetadata(licenseId.getMetadata());
            LicenseResponse licenseResponse = this.licenseGenerator.generate(input);
            this.createLicenseGeneratedEvent(licenseId, macAddress);
            return licenseResponse;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(ErrorService.response(e.getMessage()));
        }
    }

    private void createLicenseGeneratedEvent(LdapLicenseId licenseId, String macAddress) {
        LdapLicenseGeneratedEvent statistic = new LdapLicenseGeneratedEvent();
        statistic.setCreationDate(new Date());
        statistic.setMacAddress(Strings.isNullOrEmpty((String)macAddress) ? null : macAddress);
        this.statisticService.saveGeneratedEvent(statistic, licenseId.getLicenseId());
    }

    private LdapLicenseCrypt getLicenseCrypt(String licenseCryptDN, String licenseId) {
        try {
            LdapLicenseCrypt entity = this.licenseCryptService.get(licenseCryptDN);
            if (entity != null) {
                return entity;
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        LOG.error("Crypt object is corrupted for License ID: " + licenseId);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Crypt object is corrupted for License ID: " + licenseId)).build());
    }

    private static Date plus30DayFromNow() {
        return new Date(new Date().getTime() + TimeUnit.DAYS.toMillis(30L));
    }

    public String generatedLicenseAsString(String licenseId, int count, String macAddress) {
        if (count <= 1) {
            count = 1;
        }
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            list.add(this.generateLicense(licenseId, macAddress));
        }
        return Jackson.asJsonSilently((Object)list);
    }

    @GET
    @Path(value="/generate")
    @Produces(value={"application/json"})
    public Response generateGet(@QueryParam(value="licenseId") String licenseId, @QueryParam(value="count") int count, @QueryParam(value="macAddress") String macAddress) {
        return Response.ok().entity((Object)this.generatedLicenseAsString(licenseId, count, macAddress)).build();
    }

    @POST
    @Path(value="/generate")
    @Produces(value={"application/json"})
    public Response generatePost(@FormParam(value="licenseId") String licenseId, @FormParam(value="count") int count, @FormParam(value="macAddress") String macAddress) {
        return Response.ok().entity((Object)this.generatedLicenseAsString(licenseId, count, macAddress)).build();
    }

    @POST
    @Path(value="/generateLicenseId/{licenseCount}")
    @Produces(value={"application/json"})
    public Response generateLicenseIdPost(@PathParam(value="licenseCount") int licenseCount, LicenseMetadata licenseMetadata) {
        this.validationService.validate(licenseMetadata);
        if (Strings.isNullOrEmpty((String)licenseMetadata.getCustomerName())) {
            throw new WebApplicationException(ErrorService.response("'customer_name' attribute is not valid or empty."));
        }
        LdapLicenseCrypt crypt = this.licenseCryptService.generate(licenseMetadata.getCustomerName());
        this.licenseCryptService.save(crypt);
        List<LdapLicenseId> licenseIdList = this.licenseIdService.generateLicenseIdsWithPersistence(licenseCount, crypt, licenseMetadata);
        ArrayList idList = Lists.newArrayList();
        for (LdapLicenseId id : licenseIdList) {
            LicenseIdItem item = new LicenseIdItem();
            item.setLicenseId(id.getLicenseId());
            item.setPublicKey(crypt.getPublicKey());
            item.setPublicPassword(crypt.getPublicPassword());
            item.setLicensePassword(crypt.getLicensePassword());
            item.setCryptId(crypt.getId());
            idList.add(item);
        }
        String response = Jackson.asJsonSilently((Object)idList);
        LOG.trace(response);
        return Response.ok().entity((Object)idList).build();
    }

    @PUT
    @Path(value="/generateLicenseId/{licenseCount}/{cryptId}")
    @Produces(value={"application/json"})
    public Response generateLicenseIdsByCryptId(@PathParam(value="licenseCount") int licenseCount, @PathParam(value="cryptId") String cryptId, LicenseMetadata licenseMetadata) {
        if (Strings.isNullOrEmpty((String)cryptId)) {
            throw new WebApplicationException(ErrorService.response("'cryptId' is missed in path of the URL. (Example https://license.gluu.org/oxLicense/rest/generateLicenseId/{licenseCount}/{cryptId})"));
        }
        this.validationService.validate(licenseMetadata);
        LdapLicenseCrypt crypt = this.licenseCryptService.getById(cryptId);
        if (crypt == null) {
            throw new WebApplicationException(ErrorService.response("'cryptId' is invalid. Enable to find crypt object with such id."));
        }
        List<LdapLicenseId> licenseIdList = this.licenseIdService.generateLicenseIdsWithPersistence(licenseCount, crypt, licenseMetadata);
        ArrayList idList = Lists.newArrayList();
        for (LdapLicenseId id : licenseIdList) {
            LicenseIdItem item = new LicenseIdItem();
            item.setLicenseId(id.getLicenseId());
            item.setPublicKey(crypt.getPublicKey());
            item.setPublicPassword(crypt.getPublicPassword());
            item.setLicensePassword(crypt.getLicensePassword());
            item.setCryptId(crypt.getId());
            idList.add(item);
        }
        String response = Jackson.asJsonSilently((Object)idList);
        LOG.trace(response);
        return Response.ok().entity((Object)idList).build();
    }

    @GET
    @Path(value="/currentMilliseconds")
    @Produces(value={"text/plain"})
    public Response currentMilliseconds() {
        return Response.ok().entity((Object)System.currentTimeMillis()).build();
    }
}

