/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.license.client.js.Product;
import org.gluu.oxd.licenser.server.service.ErrorService;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationService {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationService.class);
    @Inject
    LicenseIdService licenseIdService;

    public LdapLicenseId getLicenseId(String licenseId) {
        try {
            LdapLicenseId byId;
            if (!Strings.isNullOrEmpty((String)licenseId) && (byId = this.licenseIdService.getById(licenseId)) != null) {
                return byId;
            }
            LOG.error("License ID is blank" + licenseId);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        throw new WebApplicationException(ErrorService.response("Failed to find License ID with id: " + licenseId));
    }

    public String validateNotEmpty(Map<String, String> properties, String propertyName) {
        String value = properties.get(propertyName);
        if (StringUtils.isBlank((String)value)) {
            throw new WebApplicationException(ErrorService.response("'" + propertyName + "' MUST NOT be blank."));
        }
        return value;
    }

    public static void validateHours(int hours) {
        if (hours <= 0 || hours > 1000) {
            throw new WebApplicationException(ErrorService.response("'hours' must be in range [1..1000]"));
        }
    }

    public void validate(LicenseMetadata metadata) {
        if (Product.getProducts((LicenseMetadata)metadata).isEmpty()) {
            throw new WebApplicationException(ErrorService.response("'products' attribute is not valid or empty. Supported products values are: " + Product.supportedProductsString()));
        }
        if (metadata.getExpirationDate() == null) {
            throw new WebApplicationException(ErrorService.response("'expiration_date' is not set"));
        }
    }
}

