/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.guice;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.gluu.orm.util.properties.FileConfiguration;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.license.client.js.JsonFileConfiguration;
import org.gluu.oxd.licenser.server.KeyPairService;
import org.gluu.oxd.licenser.server.LicenseGenerator;
import org.gluu.oxd.licenser.server.conf.ConfigurationFactory;
import org.gluu.oxd.licenser.server.ldap.Conf;
import org.gluu.oxd.licenser.server.service.LdapStructureChecker;
import org.gluu.oxd.licenser.server.service.LicenseCryptService;
import org.gluu.oxd.licenser.server.service.LicenseGeneratedStatService;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.service.StatisticUpdator;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.gluu.oxd.licenser.server.ws.GenerateLicenseWS;
import org.gluu.oxd.licenser.server.ws.MetadataWS;
import org.gluu.oxd.licenser.server.ws.StatisticWS;
import org.gluu.oxd.licenser.server.ws.UmaProtector;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.persist.model.base.DummyEntry;
import org.gluu.persist.service.PersistanceFactoryService;
import org.gluu.persist.service.StandalonePersistanceFactoryService;
import org.gluu.util.Util;
import org.gluu.util.security.PropertiesDecrypter;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(AppModule.class);
    private static final String ENCRYPTION_KEY = "123456789012345678901234567890";
    private PersistanceFactoryService persistanceFactoryService;
    private PersistenceConfiguration persistenceConfiguration;

    protected void configure() {
        this.bind(KeyPairService.class);
        this.bind(LicenseGenerator.class);
        this.bind(ValidationService.class);
        this.bind(LicenseIdService.class);
        this.bind(LicenseCryptService.class);
        this.bind(LicenseGeneratedStatService.class);
        this.bind(StatisticService.class);
        this.bind(StatisticUpdator.class);
        this.bind(UmaProtector.class);
        this.bind(GenerateLicenseWS.class);
        this.bind(MetadataWS.class);
        this.bind(StatisticWS.class);
    }

    @Provides
    @Singleton
    public PersistenceEntryManager provideLdapManager() throws StringEncrypter.EncryptionException {
        Properties connectionProperties = this.preparePersistanceProperties();
        PersistenceEntryManager persistenceEntryManager = this.getPersistenceEntryManagerFactory().createEntryManager(connectionProperties);
        LOG.info("Created: {} with operation service: {}", new Object[]{persistenceEntryManager, persistenceEntryManager.getOperationService()});
        DummyEntry base = (DummyEntry)persistenceEntryManager.find(DummyEntry.class, (Object)"o=gluu");
        Preconditions.checkNotNull((Object)base);
        return persistenceEntryManager;
    }

    protected Properties preparePersistanceProperties() throws StringEncrypter.EncryptionException {
        this.persistanceFactoryService = new StandalonePersistanceFactoryService();
        this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration("oxLicense.properties");
        FileConfiguration fileConfiguration = this.persistenceConfiguration.getConfiguration();
        Properties decryptedConnectionProperties = PropertiesDecrypter.decryptProperties((StringEncrypter)StringEncrypter.instance((String)ENCRYPTION_KEY), (Properties)ConfigurationFactory.getLdapConfiguration().getProperties());
        fileConfiguration.getProperties().setProperty("ldap.bindPassword", decryptedConnectionProperties.getProperty("bindPassword"));
        return fileConfiguration.getProperties();
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory() {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(this.persistenceConfiguration);
        return persistenceEntryManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provides
    @Singleton
    public JsonFileConfiguration provideJsonConfiguration() {
        FileInputStream stream = null;
        try {
            LOG.info("Configuration file location: {}", (Object)this.getConfigFileLocation());
            File configFile = new File(this.getConfigFileLocation());
            if (configFile.exists()) {
                stream = new FileInputStream(configFile);
            } else {
                LOG.error("No configuration file. Fail to start! Location: " + this.getConfigFileLocation());
            }
            JsonFileConfiguration jsonFileConfiguration = (JsonFileConfiguration)Util.createJsonMapper().readValue((InputStream)stream, JsonFileConfiguration.class);
            IOUtils.closeQuietly((InputStream)stream);
            return jsonFileConfiguration;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            JsonFileConfiguration jsonFileConfiguration = null;
            return jsonFileConfiguration;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public String getConfigFileLocation() {
        return ConfigurationFactory.CONFIG_FILE_LOCATION;
    }

    public String getUmaProtectFileLocation() {
        return ConfigurationFactory.UMA_PROTECT_FILE_LOCATION;
    }

    @Provides
    @Singleton
    public Configuration provideConfiguration(PersistenceEntryManager ldapManager, JsonFileConfiguration jsonFileConfiguration) throws IOException {
        String dn = this.persistenceConfiguration.getConfiguration().getString("ldap.configurationEntryDN");
        try {
            Conf conf = (Conf)ldapManager.find(Conf.class, (Object)dn);
            if (conf != null) {
                Configuration configuration = (Configuration)Util.createJsonMapper().readValue(conf.getConf(), Configuration.class);
                new LdapStructureChecker(ldapManager, configuration).checkLdapStructure();
                return configuration;
            }
            LOG.error("Conf object is null.");
        }
        catch (EntryPersistenceException e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            LOG.info("Unable to find configuration in LDAP, try to create configuration entry in LDAP... ");
            if (this.persistenceConfiguration.getConfiguration().getBoolean("ldap.createLdapConfigurationEntryIfNotExist")) {
                if (jsonFileConfiguration != null) {
                    Conf c = new Conf();
                    c.setDn(this.persistenceConfiguration.getConfiguration().getString("ldap.configurationEntryDN"));
                    c.setConf(Util.createJsonMapper().writeValueAsString((Object)jsonFileConfiguration));
                    LOG.info("Persisting ldap conf: " + c);
                    try {
                        ldapManager.persist((Object)c);
                        LOG.info("Configuration entry is created in LDAP.");
                    }
                    catch (Exception ex) {
                        LOG.error(e.getMessage(), (Throwable)ex);
                    }
                    new LdapStructureChecker(ldapManager, (Configuration)jsonFileConfiguration).checkLdapStructure();
                    return jsonFileConfiguration;
                }
                LOG.error("Unable to read configuration from file: oxLicense-config.json");
            }
            LOG.error("Skip configuration creation because createLdapConfigurationEntryIfNotExist is set to false instead of true in oxLicense-config.json");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        LOG.error("Failed to create configuration.");
        return null;
    }
}

