/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.stat;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.licenser.server.Utils;

public class MacKey {
    private final String dateString;
    private final String macAddress;

    public MacKey(LdapClientEvent stat) {
        this.dateString = Utils.yearAndMonthAndDayOfMonth(stat.getCreationDate());
        this.macAddress = stat.getMacAddress();
    }

    public String getDateString() {
        return this.dateString;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public static Map<String, Integer> countMap(Set<MacKey> value) {
        HashMap map = Maps.newHashMap();
        for (MacKey v : value) {
            if (Strings.isNullOrEmpty((String)v.getMacAddress())) continue;
            Integer counter = (Integer)map.get(v.getMacAddress());
            if (counter == null) {
                map.put(v.getMacAddress(), 1);
                continue;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            map.put(v.getMacAddress(), counter);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacKey macKey = (MacKey)o;
        return !(this.dateString == null ? macKey.dateString != null : !this.dateString.equals(macKey.dateString)) && !(this.macAddress == null ? macKey.macAddress != null : !this.macAddress.equals(macKey.macAddress));
    }

    public int hashCode() {
        int result = this.dateString != null ? this.dateString.hashCode() : 0;
        result = 31 * result + (this.macAddress != null ? this.macAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MacKey{dateString='" + this.dateString + '\'' + ", macAddress='" + this.macAddress + '\'' + '}';
    }
}

