/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.license.test;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.UUID;
import junit.framework.Assert;
import net.nicholaswilliams.java.licensing.SignedLicense;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.data.LicenseResponse;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.license.client.lib.ALicense;
import org.gluu.oxd.license.client.lib.ALicenseManager;
import org.gluu.oxd.license.client.lib.LicenseSerializationUtilities;
import org.gluu.oxd.license.test.TLicenseMetadata;
import org.gluu.oxd.license.test.TestAppModule;
import org.gluu.oxd.licenser.server.service.LicenseCryptService;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.gluu.oxd.licenser.server.ws.GenerateLicenseWS;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestAppModule.class})
public class LicenseGeneratorTest {
    @Inject
    LicenseCryptService licenseCryptService;
    @Inject
    GenerateLicenseWS generateLicenseWS;
    @Inject
    LicenseIdService licenseIdService;
    private LdapLicenseId licenseId;
    private LdapLicenseCrypt crypt;

    @BeforeClass
    public void setUp() {
        LicenseMetadata metadata = TLicenseMetadata.standard();
        this.crypt = this.licenseCryptService.generate();
        this.licenseCryptService.save(this.crypt);
        this.licenseId = this.licenseIdService.generate(this.crypt.getDn(), metadata);
        this.licenseIdService.save(this.licenseId);
    }

    @Test
    public void generateLicense() throws IOException {
        LicenseResponse license = this.generateLicenseWS.generateLicense(this.licenseId.getLicenseId(), UUID.randomUUID().toString());
        Assert.assertTrue((license != null && license.getEncodedLicense() != null ? 1 : 0) != 0);
        System.out.println("Generated license: " + license.getEncodedLicense());
        SignedLicense signedLicense = LicenseSerializationUtilities.deserialize((String)license.getEncodedLicense());
        this.assertValidLicense(signedLicense);
        this.assertInValidLicense(signedLicense);
    }

    private void assertValidLicense(SignedLicense signedLicense) throws IOException {
        ALicenseManager manager = new ALicenseManager(this.crypt.getPublicKey(), this.crypt.getPublicPassword(), signedLicense, this.crypt.getLicensePassword());
        ALicense decryptedLicense = manager.decryptAndVerifyLicense(signedLicense);
        manager.validateLicense(decryptedLicense);
        System.out.println("License is valid!");
        String subject = decryptedLicense.getSubject();
        LicenseMetadata metadata = (LicenseMetadata)Jackson.createJsonMapper().readValue(subject, LicenseMetadata.class);
        System.out.println("Metadata: " + metadata);
    }

    private void assertInValidLicense(SignedLicense signedLicense) {
        try {
            String licensePassword = "a";
            ALicenseManager manager = new ALicenseManager(this.crypt.getPublicKey(), this.crypt.getPublicPassword(), signedLicense, "a");
            ALicense decryptedLicense = manager.decryptAndVerifyLicense(signedLicense);
            manager.validateLicense(decryptedLicense);
            System.out.println("License is valid!");
            String subject = decryptedLicense.getSubject();
            LicenseMetadata metadata = (LicenseMetadata)Jackson.createJsonMapper().readValue(subject, LicenseMetadata.class);
            System.out.println("Metadata: " + metadata);
        }
        catch (Exception e) {
            return;
        }
        throw new RuntimeException("Validation passed even with WRONG license password. Something went wrong :(");
    }
}

