package org.gluu.oxd.licenser.server.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.licenser.server.ldap.LdapOu;
import org.gluu.oxd.licenser.server.ldap.LdapStructure;
import org.gluu.persist.PersistenceEntryManager;

import java.util.Arrays;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 30/09/2014
 */

public class LdapStructureChecker {

    private static final Logger LOG = LoggerFactory.getLogger(LdapStructureChecker.class);

    private PersistenceEntryManager ldapEntryManager;
    private LdapStructure ldapStructure;

    public LdapStructureChecker(PersistenceEntryManager ldapEntryManager, Configuration conf) {
        this.ldapEntryManager = ldapEntryManager;
        this.ldapStructure = new LdapStructure(conf);
    }

    public void checkLdapStructure() {
        LdapOu customerBaseDn = new LdapOu();
        customerBaseDn.setDn(ldapStructure.getCustomerBaseDn());
        customerBaseDn.setOu(ldapStructure.getCustomerOu());

        LdapOu licenseIdBaseDn = new LdapOu();
        licenseIdBaseDn.setDn(ldapStructure.getLicenseIdBaseDn());
        licenseIdBaseDn.setOu(ldapStructure.getLicenseIdOu());

        LdapOu licenseCryptBaseDn = new LdapOu();
        licenseCryptBaseDn.setDn(ldapStructure.getLicenseCryptBaseDn());
        licenseCryptBaseDn.setOu(ldapStructure.getLicenseCryptOu());

        for (LdapOu ldapOu : Arrays.asList(customerBaseDn, licenseIdBaseDn, licenseCryptBaseDn)) {
            if (!ldapEntryManager.contains(ldapOu)) {
                ldapEntryManager.persist(ldapOu);
                LOG.info("Created: " + ldapOu.getDn());
            }
        }
    }
}
