package org.gluu.oxd.licenser.server.ws;

import org.apache.commons.lang.StringUtils;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 24/06/2016
 */

public class PathPatcher {

    private PathPatcher() {
    }

    public static String patchPath(String path) {
        if (path != null) {
            path = dropTailAfter(path, "/generateLicenseId");
        }
        return path;
    }

    public static String dropTailAfter(String path, String stringEndsWith) {
        if (StringUtils.isNotBlank(path) && path.contains(stringEndsWith)) {
            return StringUtils.substringBefore(path, stringEndsWith) + stringEndsWith;
        }
        return path;
    }
}
