/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import java.util.Arrays;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.licenser.server.ldap.LdapOu;
import org.gluu.oxd.licenser.server.ldap.LdapStructure;
import org.gluu.persist.PersistenceEntryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapStructureChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LdapStructureChecker.class);
    private PersistenceEntryManager ldapEntryManager;
    private LdapStructure ldapStructure;

    public LdapStructureChecker(PersistenceEntryManager ldapEntryManager, Configuration conf) {
        this.ldapEntryManager = ldapEntryManager;
        this.ldapStructure = new LdapStructure(conf);
    }

    public void checkLdapStructure() {
        LdapOu customerBaseDn = new LdapOu();
        customerBaseDn.setDn(this.ldapStructure.getCustomerBaseDn());
        customerBaseDn.setOu(this.ldapStructure.getCustomerOu());
        LdapOu licenseIdBaseDn = new LdapOu();
        licenseIdBaseDn.setDn(this.ldapStructure.getLicenseIdBaseDn());
        licenseIdBaseDn.setOu(this.ldapStructure.getLicenseIdOu());
        LdapOu licenseCryptBaseDn = new LdapOu();
        licenseCryptBaseDn.setDn(this.ldapStructure.getLicenseCryptBaseDn());
        licenseCryptBaseDn.setOu(this.ldapStructure.getLicenseCryptOu());
        for (LdapOu ldapOu : Arrays.asList(customerBaseDn, licenseIdBaseDn, licenseCryptBaseDn)) {
            if (this.ldapEntryManager.contains((Object)ldapOu)) continue;
            this.ldapEntryManager.persist((Object)ldapOu);
            LOG.info("Created: " + ldapOu.getDn());
        }
    }
}

