/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.ldap;

import com.google.inject.Inject;
import org.gluu.oxd.license.client.js.Configuration;

public class LdapStructure {
    private Configuration conf;

    @Inject
    public LdapStructure(Configuration conf) {
        this.conf = conf;
    }

    public String getBaseDn() {
        return this.conf.getBaseDn();
    }

    public String getCustomerBaseDn() {
        return LdapStructure.ou(this.getCustomerOu()) + this.conf.getBaseDn();
    }

    public String getCustomerOu() {
        return "customer";
    }

    public String getLicenseIdOu() {
        return "licenseId";
    }

    public String getLicenseCryptOu() {
        return "licenseCrypt";
    }

    public String getLicenseCryptBaseDn() {
        return LdapStructure.ou(this.getLicenseCryptOu()) + this.conf.getBaseDn();
    }

    public String getLicenseIdBaseDn() {
        return LdapStructure.ou(this.getLicenseIdOu()) + this.conf.getBaseDn();
    }

    public String getStatisticBaseDn(String licenseId) {
        return "licenseId=" + licenseId + "," + LdapStructure.ou(this.getLicenseIdOu()) + this.conf.getBaseDn();
    }

    private static String ou(String ou) {
        return String.format("ou=%s,", ou);
    }
}

