/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.ws;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.js.InfoMacAddressRequest;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.licenser.server.model.LicenseMetadataResponse;
import org.gluu.oxd.licenser.server.service.ErrorService;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest")
public class MetadataWS {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataWS.class);
    @Inject
    ValidationService validationService;
    @Inject
    ErrorService errorService;
    @Inject
    LicenseIdService licenseIdService;
    @Inject
    StatisticService statisticService;

    @GET
    @Path(value="/metadata")
    @Produces(value={"application/json"})
    public Response generateGet(@QueryParam(value="licenseId") String licenseId) {
        LOG.debug("Metadata request, licenseId: " + licenseId);
        String json = Jackson.asJsonSilently((Object)((Object)new LicenseMetadataResponse(this.metadata(licenseId))));
        return Response.ok().entity((Object)json).build();
    }

    @PUT
    @Path(value="/metadata")
    @Produces(value={"application/json"})
    public Response update(LicenseMetadata metadata) {
        try {
            LOG.debug("Updating licenseId: " + metadata.getLicenseId() + ", metadata: " + metadata);
            this.validationService.validate(metadata);
            LdapLicenseId licenseId = this.validationService.getLicenseId(metadata.getLicenseId());
            licenseId.setMetadataAsObject(metadata);
            licenseId.setMetadata(Jackson.asJsonSilently((Object)metadata));
            this.licenseIdService.merge(licenseId);
            LOG.debug("LicenseId: " + metadata.getLicenseId() + " updated.");
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(ErrorService.response(e.getMessage()));
        }
    }

    public LicenseMetadata metadata(String licenseIdStr) {
        try {
            LdapLicenseId licenseId = this.validationService.getLicenseId(licenseIdStr);
            LicenseMetadata metadata = (LicenseMetadata)Jackson.createJsonMapper().readValue(licenseId.getMetadata(), LicenseMetadata.class);
            metadata.setLicenseId(licenseId.getLicenseId());
            return metadata;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(ErrorService.response(e.getMessage()));
        }
    }

    @POST
    @Path(value="/info/macAddress")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response infoMacAddress(InfoMacAddressRequest request) {
        try {
            LOG.debug("Info request: " + request);
            this.validationService.getLicenseId(request.getLicenseId());
            List<LdapClientEvent> all = this.statisticService.getAll(request.getLicenseId());
            HashMap<String, ArrayList<LdapClientEvent>> map = new HashMap<String, ArrayList<LdapClientEvent>>();
            for (LdapClientEvent event : all) {
                if (!request.getMacAddresses().contains(event.getMacAddress())) continue;
                ArrayList<LdapClientEvent> value = (ArrayList<LdapClientEvent>)map.get(event.getMacAddress());
                if (value == null) {
                    value = new ArrayList<LdapClientEvent>();
                    map.put(event.getMacAddress(), value);
                }
                value.add(event);
            }
            JSONObject response = new JSONObject();
            for (Map.Entry entry : map.entrySet()) {
                LdapClientEvent min = Collections.min((Collection)entry.getValue(), new Comparator<LdapClientEvent>(){

                    @Override
                    public int compare(LdapClientEvent o1, LdapClientEvent o2) {
                        return o1.getCreationDate().compareTo(o2.getCreationDate());
                    }
                });
                JSONObject properties = new JSONObject();
                properties.put("creation_date", (Object)min.getCreationDate());
                response.put((String)entry.getKey(), (Object)properties);
            }
            return Response.ok().entity((Object)response.toString(2)).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(ErrorService.response(e.getMessage()));
        }
    }
}

