/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import com.google.inject.Inject;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.StatisticUpdateRequest;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.licenser.server.service.ErrorService;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticUpdator {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticUpdator.class);
    @Inject
    ValidationService validationService;
    @Inject
    StatisticService statisticService;

    public void update(StatisticUpdateRequest request) {
        if (request.getType() == StatisticUpdateRequest.Type.CLIENT) {
            this.updateClient(request);
            return;
        }
        LOG.error("Unknown statistic update type: " + request.getType());
        throw new WebApplicationException(ErrorService.response("Unknown statistic update type: " + request.getType()));
    }

    private void updateClient(StatisticUpdateRequest request) {
        LdapLicenseId licenseId = this.validationService.getLicenseId((String)request.getProperties().get("license_id"));
        String macAddress = this.validationService.validateNotEmpty(request.getProperties(), "mac_address");
        String clientId = this.validationService.validateNotEmpty(request.getProperties(), "client_id");
        String oxdId = this.validationService.validateNotEmpty(request.getProperties(), "oxd_id");
        String clientName = (String)request.getProperties().get("client_name");
        String isClientLocal = (String)request.getProperties().get("is_client_local");
        LdapClientEvent event = new LdapClientEvent();
        event.setMacAddress(macAddress);
        event.setClientId(clientId);
        event.setClientName(clientName);
        event.setOxdId(oxdId);
        event.setClientLocal(Boolean.valueOf(Boolean.parseBoolean(isClientLocal)));
        event.setAppMetadata(Jackson.asJsonSilently((Object)request.getAppMetadata()));
        event.setCreationDate(new Date());
        this.statisticService.saveClientEvent(event, licenseId.getLicenseId());
    }
}

