/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.license.client.js.HasCreationDate;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.license.client.js.event.LdapLicenseGeneratedEvent;
import org.gluu.oxd.licenser.server.Utils;
import org.gluu.oxd.licenser.server.ldap.LdapStructure;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.gluu.oxd.licenser.server.stat.ClientIdKey;
import org.gluu.oxd.licenser.server.stat.MacKey;
import org.gluu.oxd.licenser.server.stat.Stat;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticService {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticService.class);
    @Inject
    PersistenceEntryManager ldapEntryManager;
    @Inject
    Configuration conf;
    @Inject
    LdapStructure ldapStructure;
    @Inject
    ValidationService validationService;

    public void merge(LdapClientEvent entity) {
        try {
            this.ldapEntryManager.merge((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public LdapLicenseGeneratedEvent saveGeneratedEvent(LdapLicenseGeneratedEvent entity, String licenseId) {
        try {
            if (Strings.isNullOrEmpty((String)entity.getId())) {
                entity.setId(UUID.randomUUID().toString());
            }
            if (Strings.isNullOrEmpty((String)entity.getDn())) {
                entity.setDn(this.dn(entity.getId(), licenseId));
            }
            this.ldapEntryManager.persist((Object)entity);
            return entity;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LdapClientEvent saveClientEvent(LdapClientEvent event, String licenseId) {
        return this.saveClientEvent(event, licenseId, false);
    }

    public LdapClientEvent saveClientEvent(LdapClientEvent event, String licenseId, boolean forcePersistence) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)licenseId), (Object)"License ID can't be blank.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)event.getOxdId()), (Object)"oxdid can't be blank.");
            boolean shouldPersist = this.getByLicenseIdAndOxdIdInLastHours(licenseId, event.getOxdId(), 24).isEmpty();
            if (shouldPersist || forcePersistence) {
                if (event.getCreationDate() == null) {
                    event.setCreationDate(new Date());
                }
                this.setDnIfEmpty(event, licenseId);
                this.ldapEntryManager.persist((Object)event);
                LOG.trace("Persisted event: " + event);
                return event;
            }
            LOG.trace("Skip persistence of client event, licenseId: " + licenseId + ", event: " + event);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void setDnIfEmpty(LdapClientEvent entity, String licenseId) {
        if (Strings.isNullOrEmpty((String)entity.getId())) {
            entity.setId(UUID.randomUUID().toString());
        }
        if (Strings.isNullOrEmpty((String)entity.getDn())) {
            entity.setDn(this.dn(entity.getId(), licenseId));
        }
    }

    private String dn(String id, String licenseId) {
        return "uniqueIdentifier=" + id + "," + this.ldapStructure.getStatisticBaseDn(licenseId);
    }

    public LdapClientEvent get(String dn) {
        return (LdapClientEvent)this.ldapEntryManager.find(LdapClientEvent.class, (Object)dn);
    }

    public List<LdapClientEvent> getAll(String licenseId) {
        try {
            Filter filter = Filter.createPresenceFilter((String)"uniqueIdentifier");
            return this.ldapEntryManager.findEntries(this.ldapStructure.getStatisticBaseDn(licenseId), LdapClientEvent.class, filter);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<LdapLicenseGeneratedEvent> getAllLicenseGenerated(String licenseId) {
        try {
            Filter filter = Filter.createPresenceFilter((String)"uniqueIdentifier");
            return this.ldapEntryManager.findEntries(this.ldapStructure.getStatisticBaseDn(licenseId), LdapLicenseGeneratedEvent.class, filter);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<LdapClientEvent> getByLicenseIdAndOxdId(String licenseId, String oxdId) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"oxdId", (Object)oxdId);
            List<LdapClientEvent> entries = this.ldapEntryManager.findEntries(this.ldapStructure.getStatisticBaseDn(licenseId), LdapClientEvent.class, filter);
            return entries != null ? entries : Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<LdapClientEvent> getByLicenseIdAndOxdIdInLastHours(String licenseId, String oxdId, int hours) {
        List<LdapClientEvent> all = this.getByLicenseIdAndOxdId(licenseId, oxdId);
        return StatisticService.filter(all, StatisticService.timePredicate(hours));
    }

    public static <T> List<T> filter(List<T> all, Predicate<T> predicate) {
        ArrayList filtered = Lists.newArrayList();
        if (all != null && !all.isEmpty()) {
            for (T item : all) {
                if (!predicate.apply(item)) continue;
                filtered.add(item);
            }
        }
        LOG.trace("ALL size: " + (all != null ? all.size() : 0) + ", filtered size: " + filtered.size());
        return filtered;
    }

    public List<LdapClientEvent> getForPeriod(String licenseId, Date from, Date to) {
        try {
            String filter = String.format("&(uniqueIdentifier=*)(oxCreationDate>=%s)(oxCreationDate<=%s)", StaticUtils.encodeGeneralizedTime((Date)from), StaticUtils.encodeGeneralizedTime((Date)to));
            LOG.trace("period filter: " + filter);
            return this.ldapEntryManager.findEntries(this.ldapStructure.getStatisticBaseDn(licenseId), LdapClientEvent.class, Filter.create((String)filter));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static <T extends HasCreationDate> Predicate<T> timePredicate(int hours) {
        ValidationService.validateHours(hours);
        final Calendar inPast = Calendar.getInstance();
        inPast.add(10, -hours);
        return new Predicate<T>(){

            public boolean apply(T input) {
                return input.getCreationDate().after(inPast.getTime());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public String lastHoursLicenseIdStatistic(String licenseId, int hours) {
        this.validationService.getLicenseId(licenseId);
        try {
            List<LdapClientEvent> filtered = StatisticService.filter(this.getAll(licenseId), StatisticService.timePredicate(hours));
            HashMap<String, void> macAddressToCounter = new HashMap<String, void>();
            for (LdapClientEvent ldapClientEvent : filtered) {
                void var7_10;
                Integer n = (Integer)macAddressToCounter.get(ldapClientEvent.getMacAddress());
                if (n == null) {
                    Integer n2 = 1;
                } else {
                    Integer n3;
                    Integer n4 = n;
                    Integer n5 = n3 = Integer.valueOf(n + 1);
                }
                macAddressToCounter.put(ldapClientEvent.getMacAddress(), var7_10);
            }
            LOG.trace("macAddressToCounter size: " + macAddressToCounter.size());
            JSONObject lastHoursStatistic = new JSONObject();
            for (Map.Entry entry : macAddressToCounter.entrySet()) {
                lastHoursStatistic.put((String)entry.getKey(), entry.getValue());
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("statistic", (Object)lastHoursStatistic);
            jSONObject.put("total_generated_licenses", filtered.size());
            return jSONObject.toString(2);
        }
        catch (Exception e) {
            LOG.error("Failed to construct statistic for license_id: " + licenseId, (Throwable)e);
            return "{\"error\":\"Failed to construct statistic for license_id: " + licenseId + "\"}";
        }
    }

    public String clientMonthlyStatistic(String licenseId) {
        this.validationService.getLicenseId(licenseId);
        try {
            Map<String, Stat> map = this.constructMonthlyMap(licenseId);
            JSONObject monthlyStatistic = new JSONObject();
            for (Map.Entry<String, Stat> entity : map.entrySet()) {
                JSONObject stat = new JSONObject();
                stat.put("local_clients", (Object)this.clientsJsonArray(entity.getValue().getLocalClientIdKeys()));
                stat.put("web_clients", (Object)this.clientsJsonArray(entity.getValue().getWebClientIdKeys()));
                monthlyStatistic.put(entity.getKey(), (Object)stat);
            }
            JSONObject wrapper = new JSONObject();
            wrapper.put("monthly_statistic", (Object)monthlyStatistic);
            return wrapper.toString(2);
        }
        catch (Exception e) {
            LOG.error("Failed to construct statistic for license_id: " + licenseId, (Throwable)e);
            return "{\"error\":\"Failed to construct statistic for license_id: " + licenseId + "\"}";
        }
    }

    private JSONArray clientsJsonArray(Set<ClientIdKey> clients) throws JSONException {
        JSONArray array = new JSONArray();
        Map<String, Integer> countMap = ClientIdKey.countMap(clients);
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            ClientIdKey clientIdKey = ClientIdKey.byClientId(clients, entry.getKey());
            Set<ClientIdKey> recordsOfClient = ClientIdKey.filterByClientId(clients, entry.getKey());
            JSONObject object = new JSONObject();
            object.put("client_id", (Object)entry.getKey());
            object.put("oxd_id", (Object)clientIdKey.getOxdId());
            object.put("client_name", (Object)clientIdKey.getClientName());
            object.put("count", (Object)entry.getValue());
            object.put("mac_address", (Object)clientIdKey.getMacAddress());
            object.put("programming_language", (Object)(clientIdKey.getMetadata() != null ? clientIdKey.getMetadata().getProgrammingLanguage() : ""));
            object.put("app_name", (Object)(clientIdKey.getMetadata() != null ? clientIdKey.getMetadata().getAppName() : ""));
            object.put("app_version", (Object)(clientIdKey.getMetadata() != null ? clientIdKey.getMetadata().getAppVersion() : ""));
            object.put("server_name", (Object)(clientIdKey.getMetadata() != null ? (String)clientIdKey.getMetadata().getData().get("server_name") : ""));
            object.put("active_dates", StatisticService.activeDatesArray(recordsOfClient));
            object.put("first_used_at", (Object)StatisticService.firstUsedAt(recordsOfClient));
            array.put((Object)object);
        }
        return array;
    }

    private static String firstUsedAt(Set<ClientIdKey> recordsOfClient) {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (ClientIdKey record : recordsOfClient) {
            dates.add(record.getCreationDate());
        }
        if (dates.isEmpty()) {
            return "none";
        }
        return Utils.yearAndMonthAndDayOfMonth((Date)Collections.min(dates));
    }

    private static Set<String> activeDatesArray(Set<ClientIdKey> clients) {
        HashSet<String> result = new HashSet<String>();
        if (clients != null && !clients.isEmpty()) {
            for (ClientIdKey key : clients) {
                result.add(key.getCreationDateAsYY_MM_DD());
            }
        }
        return result;
    }

    private Map<String, Stat> constructMonthlyMap(String licenseId) {
        List<LdapClientEvent> entities = this.getAll(licenseId);
        TreeMap map = Maps.newTreeMap();
        for (LdapClientEvent s : entities) {
            String key = Utils.yearAndMonth(s.getCreationDate());
            Stat stat = (Stat)map.get(key);
            if (stat == null) {
                stat = new Stat();
                map.put(key, stat);
            }
            stat.getMacKeys().add(new MacKey(s));
            if (s.getClientLocal().booleanValue()) {
                stat.getLocalClientIdKeys().add(new ClientIdKey(s));
                continue;
            }
            stat.getWebClientIdKeys().add(new ClientIdKey(s));
        }
        return map;
    }
}

