/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.nicholaswilliams.java.licensing.encryption.RSAKeyPairGenerator;
import org.apache.commons.lang.RandomStringUtils;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.lib.LicenseSerializationUtilities;
import org.gluu.oxd.licenser.server.ldap.LdapStructure;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseCryptService {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseCryptService.class);
    @Inject
    PersistenceEntryManager ldapEntryManager;
    @Inject
    Configuration conf;
    @Inject
    LdapStructure ldapStructure;

    public LdapLicenseCrypt generate() {
        return this.generate("generated-" + System.currentTimeMillis());
    }

    public LdapLicenseCrypt generate(String name) {
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        KeyPair keyPair = generator.generateKeyPair();
        String privatePassword = this.randomPassword();
        String publicPassword = this.randomPassword();
        byte[] privateKeyBytes = LicenseSerializationUtilities.writeEncryptedPrivateKey((PrivateKey)keyPair.getPrivate(), (char[])privatePassword.toCharArray());
        byte[] publicKeyBytes = LicenseSerializationUtilities.writeEncryptedPublicKey((PublicKey)keyPair.getPublic(), (char[])publicPassword.toCharArray());
        return new LdapLicenseCrypt().setName(name).setPrivateKey(BaseEncoding.base64().encode(privateKeyBytes)).setPublicKey(BaseEncoding.base64().encode(publicKeyBytes)).setPrivatePassword(privatePassword).setPublicPassword(publicPassword).setLicensePassword(this.randomPassword());
    }

    public String randomPassword() {
        return RandomStringUtils.randomAlphanumeric((int)20);
    }

    public List<LdapLicenseCrypt> getAll() {
        try {
            Filter filter = Filter.createPresenceFilter((String)"uniqueIdentifier");
            return this.ldapEntryManager.findEntries(this.ldapStructure.getLicenseCryptBaseDn(), LdapLicenseCrypt.class, filter);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public LdapLicenseCrypt get(String dn) {
        return (LdapLicenseCrypt)this.ldapEntryManager.find(LdapLicenseCrypt.class, (Object)dn);
    }

    public LdapLicenseCrypt getById(String id) {
        return this.get(this.dn(id));
    }

    public void merge(LdapLicenseCrypt entity) {
        try {
            this.ldapEntryManager.merge((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void save(LdapLicenseCrypt entity) {
        try {
            this.setDnIfEmpty(entity);
            this.ldapEntryManager.persist((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setDnIfEmpty(LdapLicenseCrypt entity) {
        if (Strings.isNullOrEmpty((String)entity.getDn())) {
            String id = Strings.isNullOrEmpty((String)entity.getId()) ? UUID.randomUUID().toString() : entity.getId();
            entity.setId(id);
            entity.setDn(this.dn(id));
        }
    }

    public String dn(String id) {
        return String.format("uniqueIdentifier=%s,%s", id, this.ldapStructure.getLicenseCryptBaseDn());
    }

    public void remove(LdapLicenseCrypt entity) {
        try {
            this.ldapEntryManager.remove((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

