/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.license.test;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import junit.framework.Assert;
import org.gluu.oxd.license.client.js.LicenseIdItem;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.license.test.TEventGenerator;
import org.gluu.oxd.license.test.TLicenseMetadata;
import org.gluu.oxd.license.test.TestAppModule;
import org.gluu.oxd.licenser.server.Utils;
import org.gluu.oxd.licenser.server.ldap.LdapStructure;
import org.gluu.oxd.licenser.server.service.LicenseIdService;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.ws.GenerateLicenseWS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestAppModule.class})
public class StatisticServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticServiceTest.class);
    @Inject
    StatisticService statisticService;
    @Inject
    LicenseIdService licenseIdService;
    @Inject
    GenerateLicenseWS generateLicenseWS;
    @Inject
    LdapStructure ldapStructure;
    private LicenseIdItem licenseId;

    @BeforeMethod
    public void setUp() {
        LicenseMetadata metadata = TLicenseMetadata.standard();
        List licenseIds = (List)this.generateLicenseWS.generateLicenseIdPost(1, metadata).getEntity();
        this.licenseId = (LicenseIdItem)licenseIds.get(0);
        Calendar calendar = Calendar.getInstance();
        Date today = calendar.getTime();
        calendar.add(2, -1);
        Date lastMonth = calendar.getTime();
        calendar.add(2, -2);
        Date twoMonthsBefore = calendar.getTime();
        calendar.add(2, -3);
        Date treeMonthsBefore = calendar.getTime();
        this.generate(today);
        this.generate(lastMonth);
        this.generate(twoMonthsBefore);
        this.generate(treeMonthsBefore);
        LOG.trace("LicenseId: " + this.licenseId.getLicenseId());
    }

    private LdapClientEvent generate(Date creationDate) {
        LdapClientEvent saved = this.statisticService.saveClientEvent(TEventGenerator.generateClientEvent(creationDate), this.licenseId.getLicenseId());
        LdapClientEvent fetched = this.statisticService.get(saved.getDn());
        Assert.assertNotNull((Object)fetched);
        return fetched;
    }

    @AfterMethod
    public void tearDown() {
        this.licenseIdService.removeWithSubtreeByLicenseId(this.licenseId.getLicenseId());
    }

    @Test
    public void clientEventPersistedOneTimePer24hours() {
        LdapClientEvent event = TEventGenerator.generateClientEvent(new Date());
        LdapClientEvent saved = this.statisticService.saveClientEvent(event, this.licenseId.getLicenseId());
        Preconditions.checkNotNull((Object)saved);
        LdapClientEvent newEvent = TEventGenerator.generateClientEvent(new Date());
        newEvent.setOxdId(event.getOxdId());
        newEvent.setClientId(event.getClientId());
        newEvent.setClientLocal(event.getClientLocal());
        newEvent.setClientName(event.getClientName());
        LdapClientEvent newSaved = this.statisticService.saveClientEvent(newEvent, this.licenseId.getLicenseId());
        Preconditions.checkState((newSaved == null ? 1 : 0) != 0);
    }

    @Test
    public void clientEventMonthlyStatistic() throws JSONException {
        this.generate(new Date());
        LdapClientEvent event = this.generate(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -25);
        event.setCreationDate(calendar.getTime());
        event.setId(null);
        event.setDn(null);
        this.statisticService.saveClientEvent(event, this.licenseId.getLicenseId(), true);
        String jsonString = this.statisticService.clientMonthlyStatistic(this.licenseId.getLicenseId());
        JSONObject json = new JSONObject(jsonString);
        JSONObject month = json.getJSONObject("monthly_statistic").getJSONObject(Utils.yearAndMonth((Date)new Date()));
        JSONArray localClients = month.getJSONArray("local_clients");
        JSONArray webClients = month.getJSONArray("web_clients");
        Assert.assertEquals((int)localClients.length(), (int)3);
        Assert.assertEquals((int)webClients.length(), (int)0);
        boolean ok = false;
        for (int i = 0; i < localClients.length(); ++i) {
            JSONObject obj = localClients.getJSONObject(i);
            if (!obj.optString("client_id").equals(event.getClientId())) continue;
            Assert.assertEquals((int)obj.optInt("count"), (int)2);
            ok = true;
            break;
        }
        Assert.assertTrue((String)"Failed to find client event with count 2", (boolean)ok);
    }

    @Test
    public void loadByPeriod() throws IOException {
        Calendar calendar = Calendar.getInstance();
        Date today = new Date();
        calendar.add(2, -12);
        Date minus12Months = calendar.getTime();
        List forPeriod = this.statisticService.getForPeriod(this.licenseId.getLicenseId(), minus12Months, today);
        Assert.assertEquals((int)forPeriod.size(), (int)4);
        calendar = Calendar.getInstance();
        calendar.add(2, -2);
        Date minus2Months = calendar.getTime();
        forPeriod = this.statisticService.getForPeriod(this.licenseId.getLicenseId(), minus2Months, today);
        Assert.assertEquals((int)forPeriod.size(), (int)2);
        calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date minus1Months = calendar.getTime();
        forPeriod = this.statisticService.getForPeriod(this.licenseId.getLicenseId(), minus1Months, today);
        Assert.assertEquals((int)forPeriod.size(), (int)1);
    }

    @Test
    public void monthlyStatistic() throws IOException {
        this.generate(new Date());
        LdapClientEvent last = this.generate(new Date());
        last.setDn(null);
        last.setId(UUID.randomUUID().toString());
        this.statisticService.saveClientEvent(last, this.licenseId.getLicenseId());
        String json = this.statisticService.clientMonthlyStatistic(this.licenseId.getLicenseId());
        LOG.info(json);
        Assert.assertTrue((boolean)json.contains("mac_address"));
    }
}

