/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.license.test;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import net.nicholaswilliams.java.licensing.LicenseProvider;
import net.nicholaswilliams.java.licensing.ObjectSerializer;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.encryption.RSAKeyPairGenerator;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import org.gluu.oxd.license.client.lib.ALicense;
import org.gluu.oxd.license.client.lib.ALicenseManager;
import org.gluu.oxd.license.client.lib.LicenseSerializationUtilities;
import org.gluu.oxd.licenser.server.LicenseGenerator;
import org.gluu.oxd.licenser.server.LicenseGeneratorInput;
import org.testng.annotations.Test;

public class FullTest {
    @Test
    public void test() throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        KeyPair keyPair = generator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        final PublicKey publicKey = keyPair.getPublic();
        KeyFactory fact = KeyFactory.getInstance("RSA");
        String privatePassword = "private password";
        String publicPassword = "public password";
        String licensePassword = "license password";
        LicenseGeneratorInput input = new LicenseGeneratorInput();
        input.setCustomerName("Customer Name");
        input.setPrivateKey(LicenseSerializationUtilities.writeEncryptedPrivateKey((PrivateKey)privateKey, (char[])"private password".toCharArray()));
        input.setPublicKey(LicenseSerializationUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (char[])"public password".toCharArray()));
        input.setLicensePassword("license password");
        input.setPrivatePassword("private password");
        input.setPublicPassword("public password");
        input.setExpiredAt(new Date(new Date().getTime() + TimeUnit.DAYS.toMillis(1L)));
        input.setCreatedAt(new Date());
        LicenseGenerator licenseGenerator = new LicenseGenerator();
        final SignedLicense signedLicenseObject = licenseGenerator.generateSignedLicense(input);
        byte[] serializedLicense = new ObjectSerializer().writeObject((Serializable)signedLicenseObject);
        String encodedLicense = DatatypeConverter.printBase64Binary((byte[])serializedLicense);
        System.out.println(encodedLicense);
        LicenseProvider licenseProvider = new LicenseProvider(){

            public SignedLicense getLicense(Object context) {
                return signedLicenseObject;
            }
        };
        PublicKeyDataProvider publicKeyDataProvider = new PublicKeyDataProvider(){

            public byte[] getEncryptedPublicKeyData() throws KeyNotFoundException {
                return LicenseSerializationUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (char[])"public password".toCharArray());
            }
        };
        PasswordProvider publicKeyPasswordProvider = new PasswordProvider(){

            public char[] getPassword() {
                return "public password".toCharArray();
            }
        };
        PasswordProvider licensePasswordProvider = new PasswordProvider(){

            public char[] getPassword() {
                return "license password".toCharArray();
            }
        };
        ALicenseManager manager = new ALicenseManager(publicKeyDataProvider, publicKeyPasswordProvider, licenseProvider, licensePasswordProvider);
        ALicense license = manager.decryptAndVerifyLicense(signedLicenseObject);
        manager.validateLicense(license);
        System.out.println("License is valid!");
        int seats = license.getNumberOfLicenses();
        System.out.println("Seats: " + seats);
        boolean gluuFeature = manager.hasLicenseForAllFeatures((Object)input.getCustomerName(), new String[]{"FREE"});
        if (!gluuFeature) {
            throw new RuntimeException("Invalid license!");
        }
        System.out.println("GluuFeature is present!");
        boolean fakeGluuFeature = manager.hasLicenseForAllFeatures((Object)input.getCustomerName(), new String[]{"fakeGluuFeature"});
        if (fakeGluuFeature) {
            throw new RuntimeException("There is feature that we didn't add. Invalid license!");
        }
    }
}

