/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gluu.oxd.license.client.js.event.LdapLicenseGeneratedEvent;
import org.gluu.oxd.licenser.server.service.StatisticService;
import org.gluu.oxd.licenser.server.service.ValidationService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseGeneratedStatService {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseGeneratedStatService.class);
    @Inject
    ValidationService validationService;
    @Inject
    StatisticService statisticService;

    public String monthlyStatistic(String licenseId) {
        this.validationService.getLicenseId(licenseId);
        try {
            List<LdapLicenseGeneratedEvent> entities = this.statisticService.getAllLicenseGenerated(licenseId);
            Map<String, List<LdapLicenseGeneratedEvent>> map = this.constructMonthlyMap(entities);
            JSONObject monthlyStatistic = new JSONObject();
            for (Map.Entry<String, List<LdapLicenseGeneratedEvent>> entity : map.entrySet()) {
                JSONObject stat = new JSONObject();
                stat.put("license_generated_count", entity.getValue().size());
                stat.put("mac_address", this.macAddressMap(entity.getValue()));
                monthlyStatistic.put(entity.getKey(), (Object)stat);
            }
            JSONObject wrapper = new JSONObject();
            wrapper.put("monthly_statistic", (Object)monthlyStatistic);
            wrapper.put("total_generated_licenses", entities.size());
            return wrapper.toString(2);
        }
        catch (Exception e) {
            LOG.error("Failed to construct statistic for license_id: " + licenseId, (Throwable)e);
            return "{\"error\":\"Failed to construct statistic for license_id: " + licenseId + "\"}";
        }
    }

    private Map<String, Integer> macAddressMap(List<LdapLicenseGeneratedEvent> value) {
        HashMap map = Maps.newHashMap();
        for (LdapLicenseGeneratedEvent v : value) {
            if (Strings.isNullOrEmpty((String)v.getMacAddress())) continue;
            Integer counter = (Integer)map.get(v.getMacAddress());
            if (counter == null) {
                map.put(v.getMacAddress(), 1);
                continue;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            map.put(v.getMacAddress(), counter);
        }
        return map;
    }

    private Map<String, List<LdapLicenseGeneratedEvent>> constructMonthlyMap(List<LdapLicenseGeneratedEvent> entities) {
        TreeMap map = Maps.newTreeMap();
        for (LdapLicenseGeneratedEvent s : entities) {
            String key = this.yearAndMonth(s.getCreationDate());
            List monthList = (List)map.get(key);
            if (monthList == null) {
                monthList = Lists.newArrayList();
                map.put(key, monthList);
            }
            monthList.add(s);
        }
        return map;
    }

    private String yearAndMonth(Date date) {
        Calendar creationDate = Calendar.getInstance();
        creationDate.setTime(date);
        int month = creationDate.get(2) + 1;
        int year = creationDate.get(1);
        return year + "-" + month;
    }

    /*
     * WARNING - void declaration
     */
    public String lastHours(String licenseId, int hours) {
        this.validationService.getLicenseId(licenseId);
        ValidationService.validateHours(hours);
        try {
            List<LdapLicenseGeneratedEvent> filtered = StatisticService.filter(this.statisticService.getAllLicenseGenerated(licenseId), StatisticService.timePredicate(hours));
            HashMap<String, void> macAddressToCounter = new HashMap<String, void>();
            for (LdapLicenseGeneratedEvent ldapLicenseGeneratedEvent : filtered) {
                void var7_10;
                Integer n = (Integer)macAddressToCounter.get(ldapLicenseGeneratedEvent.getMacAddress());
                if (n == null) {
                    Integer n2 = 1;
                } else {
                    Integer n3;
                    Integer n4 = n;
                    Integer n5 = n3 = Integer.valueOf(n + 1);
                }
                macAddressToCounter.put(ldapLicenseGeneratedEvent.getMacAddress(), var7_10);
            }
            LOG.trace("macAddressToCounter size: " + macAddressToCounter.size());
            JSONObject lastHoursStatistic = new JSONObject();
            for (Map.Entry entry : macAddressToCounter.entrySet()) {
                lastHoursStatistic.put((String)entry.getKey(), entry.getValue());
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("statistic", (Object)lastHoursStatistic);
            jSONObject.put("total_generated_licenses", filtered.size());
            return jSONObject.toString(2);
        }
        catch (Exception e) {
            LOG.error("Failed to construct statistic for license_id: " + licenseId, (Throwable)e);
            return "{\"error\":\"Failed to construct statistic for license_id: " + licenseId + "\"}";
        }
    }
}

