/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.stat;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.js.AppMetadata;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.licenser.server.Utils;

public class ClientIdKey {
    private final String creationDateAsYY_MM_DD;
    private final Date creationDate;
    private final String clientId;
    private final String oxdId;
    private final String clientName;
    private final String macAddress;
    private final AppMetadata metadata;

    public ClientIdKey(LdapClientEvent stat) {
        this.creationDate = stat.getCreationDate();
        this.creationDateAsYY_MM_DD = Utils.yearAndMonthAndDayOfMonth(stat.getCreationDate());
        this.clientId = stat.getClientId();
        this.clientName = stat.getClientName();
        this.oxdId = stat.getOxdId();
        this.macAddress = stat.getMacAddress();
        this.metadata = ClientIdKey.parseSilently(stat.getAppMetadata());
    }

    private static AppMetadata parseSilently(String json) {
        try {
            return (AppMetadata)Jackson.createJsonMapper().readValue(json, AppMetadata.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public AppMetadata getMetadata() {
        return this.metadata;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreationDateAsYY_MM_DD() {
        return this.creationDateAsYY_MM_DD;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getOxdId() {
        return this.oxdId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public static Map<String, Integer> countMap(Set<ClientIdKey> value) {
        HashMap map = Maps.newHashMap();
        for (ClientIdKey v : value) {
            if (Strings.isNullOrEmpty((String)v.getClientId())) continue;
            Integer counter = (Integer)map.get(v.getClientId());
            if (counter == null) {
                map.put(v.getClientId(), 1);
                continue;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            map.put(v.getClientId(), counter);
        }
        return map;
    }

    public static ClientIdKey byClientId(Collection<ClientIdKey> collection, String clientId) {
        for (ClientIdKey k : collection) {
            if (!k.getClientId().equals(clientId)) continue;
            return k;
        }
        return null;
    }

    public static Set<ClientIdKey> filterByClientId(Collection<ClientIdKey> collection, String clientId) {
        HashSet<ClientIdKey> result = new HashSet<ClientIdKey>();
        for (ClientIdKey k : collection) {
            if (!k.getClientId().equals(clientId)) continue;
            result.add(k);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientIdKey that = (ClientIdKey)o;
        return !((this.clientId == null ? that.clientId != null : !this.clientId.equals(that.clientId)) || (this.creationDateAsYY_MM_DD == null ? that.creationDateAsYY_MM_DD != null : !this.creationDateAsYY_MM_DD.equals(that.creationDateAsYY_MM_DD)) || (this.oxdId == null ? that.oxdId != null : !this.oxdId.equals(that.oxdId)));
    }

    public int hashCode() {
        int result = this.creationDateAsYY_MM_DD != null ? this.creationDateAsYY_MM_DD.hashCode() : 0;
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.oxdId != null ? this.oxdId.hashCode() : 0);
        return result;
    }
}

