/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.data.ErrorResponse;
import org.gluu.oxd.license.client.data.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorService {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorService.class);

    public void throwError(Response.StatusType status, String entity) throws WebApplicationException {
        LOG.trace("status: " + status + ", entity:" + entity);
        throw new WebApplicationException(Response.status((Response.StatusType)status).entity((Object)entity).build());
    }

    public void throwError(Response.StatusType status, ErrorType errorType) throws WebApplicationException {
        this.throwError(status, Jackson.asJsonSilently((Object)ErrorResponse.fromErrorType((ErrorType)errorType)));
    }

    public void throwWebApplicationException(Throwable e) throws WebApplicationException {
        LOG.error(e.getMessage());
        throw new WebApplicationException(ErrorService.response(e.getMessage()));
    }

    public void throwWebApplicationException(String responseEntity) throws WebApplicationException {
        LOG.error(responseEntity);
        throw new WebApplicationException(ErrorService.response(responseEntity));
    }

    public static Response response(String responseEntity) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)responseEntity).build();
    }
}

